/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.swt.widgets.Display;

public final class SwtRidgetFactory {
    private static final IBindingManager DUMMY_BINDING_MAN;
    private static final DummyContainer CONTAINER;
    private static final List<Object> CONTROL_LIST;

    static {
        Display display = Display.getCurrent();
        Assert.isNotNull((Object)display);
        new DefaultRealm(display);
        DUMMY_BINDING_MAN = new DefaultBindingManager((IBindingPropertyLocator)new DummyBindingPropertyLocator(), (IControlRidgetMapper)new DefaultSwtControlRidgetMapper());
        CONTAINER = new DummyContainer();
        CONTROL_LIST = new ArrayList<Object>(1);
    }

    public static IRidget createRidget(Object control) {
        Assert.isNotNull((Object)control);
        CONTAINER.clear();
        CONTROL_LIST.clear();
        CONTROL_LIST.add(control);
        DUMMY_BINDING_MAN.injectRidgets((IRidgetContainer)CONTAINER, CONTROL_LIST);
        DUMMY_BINDING_MAN.bind((IRidgetContainer)CONTAINER, CONTROL_LIST);
        IRidget result = CONTAINER.getRidget(null);
        return result;
    }

    private SwtRidgetFactory() {
    }

    private static final class DummyBindingPropertyLocator
    implements IBindingPropertyLocator {
        private DummyBindingPropertyLocator() {
        }

        public String locateBindingProperty(Object uiControl) {
            return "dummy";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DummyContainer
    implements IRidgetContainer {
        private IRidget ridget;

        private DummyContainer() {
        }

        public void addRidget(String id, IRidget ridget) {
            this.ridget = ridget;
        }

        public void configureRidgets() {
        }

        public IRidget getRidget(String id) {
            return this.ridget;
        }

        public Collection<? extends IRidget> getRidgets() {
            return Arrays.asList(this.ridget);
        }

        void clear() {
            this.ridget = null;
        }
    }
}

