/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.databinding;

import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.riena.ui.ridgets.databinding.GregorianCalendarToStringConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToGregorianCalendarConverter;
import org.eclipse.riena.ui.ridgets.databinding.StringToNumberAllowingNullConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RidgetUpdateValueStrategy
extends UpdateValueStrategy {
    private static Map<TypePair, IConverter> converterMap;

    public RidgetUpdateValueStrategy() {
    }

    public RidgetUpdateValueStrategy(int updatePolicy) {
        super(updatePolicy);
    }

    public RidgetUpdateValueStrategy(boolean provideDefaults, int updatePolicy) {
        super(provideDefaults, updatePolicy);
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        if (fromType == String.class) {
            if (toType == Double.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveDouble();
            }
            if (toType == Float.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveFloat();
            }
            if (toType == Long.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveLong();
            }
            if (toType == Integer.TYPE) {
                return StringToNumberAllowingNullConverter.toPrimitiveInteger();
            }
        }
        if (fromType instanceof Class && toType instanceof Class) {
            String fromTypeClassName = ((Class)fromType).getName();
            String toTypeClassName = ((Class)toType).getName();
            TypePair pair = new TypePair(fromTypeClassName, toTypeClassName);
            IConverter converter = this.getConverterMap().get(pair);
            if (converter != null) {
                return converter;
            }
        }
        return super.createConverter(fromType, toType);
    }

    private Map<TypePair, IConverter> getConverterMap() {
        if (converterMap == null) {
            converterMap = new HashMap<TypePair, IConverter>();
        }
        converterMap.put(new TypePair(String.class.getName(), GregorianCalendar.class.getName()), (IConverter)new StringToGregorianCalendarConverter());
        converterMap.put(new TypePair(GregorianCalendar.class.getName(), String.class.getName()), (IConverter)new GregorianCalendarToStringConverter());
        return converterMap;
    }

    private static class TypePair {
        private final Object fromType;
        private final Object toType;

        public TypePair(Object fromType, Object toType) {
            this.fromType = fromType;
            this.toType = toType;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.fromType.equals(other.fromType) && this.toType.equals(other.toType);
        }

        public int hashCode() {
            return this.fromType.hashCode() + this.toType.hashCode();
        }
    }
}

