/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMessageBoxRidget;
import org.eclipse.riena.ui.ridgets.marker.AbstractMessageMarkerViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBoxMessageMarkerViewer
extends AbstractMessageMarkerViewer {
    private IMessageBoxRidget messageBoxRidget;

    public MessageBoxMessageMarkerViewer(IMessageBoxRidget messageBoxRidget) {
        this.messageBoxRidget = messageBoxRidget;
        this.setVisible(false);
    }

    @Override
    protected void hideMessages(IMarkableRidget ridget) {
    }

    @Override
    protected void showMessages(IMarkableRidget ridget) {
        if (this.isVisible()) {
            String message = this.getMessage();
            if (message.length() > 0) {
                this.messageBoxRidget.setText(message);
                this.messageBoxRidget.show();
            }
            this.setVisible(false);
        }
    }

    private String getMessage() {
        LinkedHashSet<IMessageMarker> allMessageMarker = new LinkedHashSet<IMessageMarker>();
        IMarkableRidget nextMarkableAdapter2 = null;
        HashSet<IMarkableRidget> localMarkableAdapter = new HashSet<IMarkableRidget>();
        localMarkableAdapter.addAll(this.getRidgets());
        for (IMarkableRidget nextMarkableAdapter2 : localMarkableAdapter) {
            allMessageMarker.addAll(this.getMessageMarker(nextMarkableAdapter2, false));
        }
        return this.constructMessage(allMessageMarker);
    }

    private String constructMessage(Collection<IMessageMarker> pMessageMarker) {
        StringWriter sw = new StringWriter();
        if (pMessageMarker != null) {
            ArrayList<IMessageMarker> sortedMarkers = new ArrayList<IMessageMarker>(pMessageMarker);
            Collections.sort(sortedMarkers, new AbstractMessageMarkerViewer.MessageMarkerComparator());
            for (IMessageMarker nextMarker : sortedMarkers) {
                if (sw.toString().trim().length() > 0) {
                    sw.write("\n");
                }
                if (nextMarker.getMessage() == null) continue;
                sw.write(nextMarker.getMessage());
            }
        }
        return sw.toString().trim();
    }
}

