/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.io.Serializable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.tree.ChangeVisibilityTreeNode;
import org.eclipse.riena.ui.ridgets.tree.DefaultTreeModel;
import org.eclipse.riena.ui.ridgets.tree.DefaultTreeNode;
import org.eclipse.riena.ui.ridgets.tree.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree.IVisibleTreeModel;
import org.eclipse.riena.ui.ridgets.tree.IVisibleTreeNode;

public class ChangeVisibilityTreeModel
extends DefaultTreeModel
implements IVisibleTreeModel {
    public ChangeVisibilityTreeModel(ITreeNode root) {
        super(root);
    }

    public Object getVisibleChild(Object parent, int index) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof IVisibleTreeNode), (String)"parent is not an instance of IVisibleTreeNode");
        return ((IVisibleTreeNode)parent).getVisibleChildAt(index);
    }

    public int getVisibleChildCount(Object parent) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof IVisibleTreeNode), (String)"parent is not an instance of IVisibleTreeNode");
        return ((IVisibleTreeNode)parent).getVisibleChildCount();
    }

    public int getIndexOfVisibleChild(Object parent, Object child) {
        Assert.isNotNull((Object)parent, (String)"parent is null");
        Assert.isTrue((boolean)(parent instanceof IVisibleTreeNode), (String)"parent is not an instance of IVisibleTreeNode");
        Assert.isNotNull((Object)child, (String)"child is null");
        Assert.isTrue((boolean)(child instanceof IVisibleTreeNode), (String)"child is not an instance of IVisibleTreeNode");
        return ((IVisibleTreeNode)parent).getVisibleIndex((IVisibleTreeNode)child);
    }

    public boolean isVisibleLeaf(Object node) {
        Assert.isNotNull((Object)node, (String)"node is null");
        Assert.isTrue((boolean)(node instanceof IVisibleTreeNode), (String)"node is not an instance of IVisibleTreeNode");
        return ((IVisibleTreeNode)node).isVisibleLeaf();
    }

    public void setTreeNodeVisibility(ChangeVisibilityTreeNode node, boolean visible) {
        int[] nodeIndexes = new int[1];
        Serializable[] nodes = new Serializable[]{node};
        if (visible) {
            node.setVisible(visible);
            nodeIndexes[0] = this.getIndexOfVisibleChild(node.getParent(), node);
            this.fireTreeNodesInserted((IObservable)this, node.getParent(), nodeIndexes, nodes);
        } else {
            nodeIndexes[0] = this.getIndexOfVisibleChild(node.getParent(), node);
            this.fireTreeNodesRemoved((IObservable)this, node.getParent(), nodeIndexes, nodes);
            node.setVisible(visible);
        }
    }

    protected int getIndex(DefaultTreeNode parent, DefaultTreeNode node) {
        return this.getIndexOfVisibleChild(parent, node);
    }

    protected int getChildCount(DefaultTreeNode newChild, DefaultTreeNode parent) {
        return this.getVisibleChildCount(parent);
    }

    public void removeNodeFromParent(DefaultTreeNode node) {
        DefaultTreeNode parent = (DefaultTreeNode)node.getParent();
        if (parent == null) {
            throw new UIBindingFailure("node does not have a parent.");
        }
        int removedNodeVisibleIndex = this.getIndex(parent, node);
        parent.remove(super.getIndex(parent, node));
        if (!(node instanceof ChangeVisibilityTreeNode) || ((ChangeVisibilityTreeNode)node).isVisible()) {
            int[] childIndex = new int[1];
            Serializable[] removedArray = new Serializable[1];
            childIndex[0] = removedNodeVisibleIndex;
            removedArray[0] = node;
            this.fireTreeNodesRemoved((IObservable)this, parent, childIndex, removedArray);
        }
    }
}

