/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.ridgets.tree.DefaultTreeNode;
import org.eclipse.riena.ui.ridgets.tree.IVisibleTreeNode;
import org.eclipse.riena.ui.ridgets.tree.ToolTipTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeVisibilityTreeNode
extends ToolTipTreeNode
implements IVisibleTreeNode {
    private boolean visible;

    public ChangeVisibilityTreeNode(Object userObject) {
        super(userObject);
        this.setVisible(true);
    }

    @Override
    public IVisibleTreeNode getVisibleChildAt(int childIndex) {
        Assert.isNotNull((Object)this.children, (String)"node has no children");
        return (IVisibleTreeNode)((Object)this.getVisibleChildren().elementAt(childIndex));
    }

    private Vector<DefaultTreeNode> getVisibleChildren() {
        Vector<DefaultTreeNode> visibleChildren = new Vector<DefaultTreeNode>();
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            DefaultTreeNode element = (DefaultTreeNode)enumeration.nextElement();
            if (element instanceof IVisibleTreeNode) {
                if (!((IVisibleTreeNode)((Object)element)).isVisible()) continue;
                visibleChildren.add(element);
                continue;
            }
            visibleChildren.add(element);
        }
        return visibleChildren;
    }

    @Override
    public int getVisibleChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.getVisibleChildren().size();
    }

    @Override
    public int getVisibleIndex(IVisibleTreeNode node) {
        Assert.isNotNull((Object)node, (String)"missing node argument");
        return this.getVisibleChildren().indexOf(node);
    }

    @Override
    public boolean isVisibleLeaf() {
        return this.getVisibleChildCount() == 0;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

