/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.riena.ui.ridgets.tree.AbstractObservableTreeNode;
import org.eclipse.riena.ui.ridgets.tree.DefaultObservableTreeModel;
import org.eclipse.riena.ui.ridgets.tree.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree.TreeModelEvent;

public class DefaultObservableTreeNode
extends AbstractObservableTreeNode {
    private DefaultObservableTreeModel model;
    private ITreeNode parent;
    protected List<DefaultObservableTreeNode> children;
    private Object userObject;

    public DefaultObservableTreeNode() {
        this.children = new ArrayList<DefaultObservableTreeNode>();
    }

    public DefaultObservableTreeNode(Object userObject) {
        this(Realm.getDefault(), userObject);
    }

    public DefaultObservableTreeNode(Realm realm, Object userObject) {
        super(realm);
        this.userObject = userObject;
        this.children = new ArrayList<DefaultObservableTreeNode>();
    }

    public DefaultObservableTreeModel getModel() {
        return this.model;
    }

    void setModel(DefaultObservableTreeModel model) {
        this.model = model;
        for (DefaultObservableTreeNode child : this.children) {
            child.setModel(model);
        }
    }

    public ITreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    public void addChild(DefaultObservableTreeNode newChild) {
        this.addChild(this.getChildCount(), newChild);
    }

    public void addChild(int index, DefaultObservableTreeNode child) {
        this.children.add(index, child);
        child.setParent(this);
        child.setModel(this.getModel());
        if (this.getModel() != null) {
            this.getModel().fireEvent(this, TreeModelEvent.createNodesInsertedInstance(this.getModel(), this, new int[]{index}, new DefaultObservableTreeNode[]{child}));
        }
    }

    public int removeFromParent() {
        if (this.getParent() != null) {
            return ((DefaultObservableTreeNode)this.getParent()).removeChild(this);
        }
        return -1;
    }

    public DefaultObservableTreeNode removeChild(int childIndex) {
        DefaultObservableTreeNode removed = this.children.remove(childIndex);
        if (this.getModel() != null) {
            this.getModel().fireEvent(this, TreeModelEvent.createNodesRemovedInstance(this.getModel(), this, new int[]{childIndex}, new DefaultObservableTreeNode[]{removed}));
        }
        removed.setParent(null);
        removed.setModel(null);
        return removed;
    }

    public int removeChild(DefaultObservableTreeNode child) {
        int childIndex = this.children.indexOf(child);
        if (childIndex >= 0) {
            this.removeChild(childIndex);
        }
        return childIndex;
    }

    public void removeAllChildren() {
        if (this.children.isEmpty()) {
            return;
        }
        int[] indexes = new int[this.getChildCount()];
        Serializable[] oldChildren = new DefaultObservableTreeNode[this.getChildCount()];
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = i;
            oldChildren[i] = (DefaultObservableTreeNode)this.getChildAt(i);
            ++i;
        }
        this.children.clear();
        if (this.getModel() != null) {
            this.getModel().fireEvent(this, TreeModelEvent.createNodesRemovedInstance(this.getModel(), this, indexes, oldChildren));
        }
        Serializable[] serializableArray = oldChildren;
        int n = oldChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Serializable removed = serializableArray[n2];
            ((DefaultObservableTreeNode)removed).setParent(null);
            ((DefaultObservableTreeNode)removed).setModel(null);
            ++n2;
        }
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(ITreeNode node) {
        return this.children.indexOf(node);
    }

    public ITreeNode getParent() {
        return this.parent;
    }

    void setParent(ITreeNode parent) {
        this.parent = parent;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        return this.userObject.toString();
    }
}

