/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.tree;

import java.io.Serializable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ObservableEvent;
import org.eclipse.riena.ui.ridgets.tree.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree.TreeDiff;
import org.eclipse.riena.ui.ridgets.tree.TreeNodeValueDiff;
import org.eclipse.riena.ui.ridgets.tree.TreeNodesInsertedDiff;
import org.eclipse.riena.ui.ridgets.tree.TreeNodesRemovedDiff;
import org.eclipse.riena.ui.ridgets.tree.TreeStructureDiff;

public class TreeModelEvent
extends ObservableEvent {
    static final Object TYPE = new Object();
    private TreeDiff diff;

    public static TreeModelEvent createValueDiffInstance(IObservable source, ITreeNode node, Object oldValue, Object newValue) {
        TreeNodeValueDiff diff = new TreeNodeValueDiff(node, oldValue, newValue);
        return new TreeModelEvent(source, diff);
    }

    public static TreeModelEvent createNodesRemovedInstance(IObservable source, ITreeNode parent, int[] childIndices, Serializable[] children) {
        TreeNodesRemovedDiff diff = new TreeNodesRemovedDiff(parent, childIndices, children);
        return new TreeModelEvent(source, diff);
    }

    public static TreeModelEvent createNodesInsertedInstance(IObservable source, ITreeNode parent, int[] childIndices, Serializable[] children) {
        TreeNodesInsertedDiff diff = new TreeNodesInsertedDiff(parent, childIndices, children);
        return new TreeModelEvent(source, diff);
    }

    public static TreeModelEvent createStructureChangedInstance(IObservable source, ITreeNode parent, int[] childIndices, Serializable[] children) {
        TreeStructureDiff diff = new TreeStructureDiff(parent, childIndices, children);
        return new TreeModelEvent(source, diff);
    }

    public TreeModelEvent(IObservable source, TreeDiff diff) {
        super(source);
        this.diff = diff;
    }

    protected Object getListenerType() {
        return TYPE;
    }

    protected void dispatch(IObservablesListener listener) {
        this.diff.dispatch(this, listener);
    }

    public ITreeNode getNode() {
        return this.diff.getNode();
    }

    public int[] getChildIndices() {
        return this.diff.getChildIndices();
    }

    public Object[] getChildren() {
        return this.diff.getChildren();
    }
}

