/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MaxLength
implements IValidator,
IExecutableExtension {
    protected int maxLength;

    public MaxLength() {
    }

    public MaxLength(int length) {
        this.maxLength = length;
    }

    public IStatus validate(Object value) {
        if (value == null || this.maxLength < 0) {
            return ValidationRuleStatus.ok();
        }
        if (value instanceof String) {
            String string = (String)value;
            int length = string.length();
            if (length > this.maxLength) {
                return ValidationRuleStatus.error(true, "'" + string + "' must not be longer than " + this.maxLength + " characters.", this);
            }
            return ValidationRuleStatus.ok();
        }
        throw new ValidationFailure("MaxLength can only validate objects of type String.");
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("[maxLength=");
        buffer.append(this.maxLength);
        buffer.append("]");
        return buffer.toString();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.maxLength = Integer.parseInt(args[0]);
        }
    }
}

