/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.ArraysUtil;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.validation.MaxLength;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MaxNumberLength
extends MaxLength {
    private DecimalFormatSymbols symbols;
    private Locale locale;

    public MaxNumberLength() {
        this(0, Locale.getDefault());
    }

    public MaxNumberLength(int length) {
        this(length, Locale.getDefault());
    }

    public MaxNumberLength(int length, Locale locale) {
        super(length);
        this.locale = locale;
    }

    public IStatus validate(Object value) {
        if (value == null) {
            return ValidationRuleStatus.ok();
        }
        if (value instanceof String) {
            String string = this.removeWhitespaceAndGroupingCharacter((String)value);
            if (string.length() > 0) {
                if (string.charAt(0) == this.getSymbols().getMinusSign()) {
                    string = string.substring(1);
                } else if (string.charAt(string.length() - 1) == this.getSymbols().getMinusSign()) {
                    string = string.substring(0, string.length() - 1);
                }
            }
            return super.validate(string);
        }
        throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type String.");
    }

    private String removeWhitespaceAndGroupingCharacter(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        int t = 0;
        while (t < string.length()) {
            char currentChar = string.charAt(t);
            if (!Character.isWhitespace(currentChar) && currentChar != this.getSymbols().getGroupingSeparator()) {
                sb.append(currentChar);
            }
            ++t;
        }
        return sb.toString();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            Object[] args = PropertiesUtils.asArray((Object)data);
            int localStart = 0;
            if (args.length > 0) {
                this.maxLength = Integer.parseInt(args[0]);
                ++localStart;
            }
            if (args.length > localStart) {
                String[] localArgs = (String[])ArraysUtil.copyRange((Object[])args, (int)localStart, (int)args.length);
                this.setLocal(localArgs);
            }
        }
    }

    protected void setLocal(String[] localArgs) {
        if (localArgs.length > 0) {
            String language = localArgs[0];
            String country = "";
            String variant = "";
            if (localArgs.length > 1) {
                country = localArgs[1];
            }
            if (localArgs.length > 2) {
                variant = localArgs[2];
            }
            this.setLocale(new Locale(language, country, variant));
        }
    }

    protected DecimalFormatSymbols getSymbols() {
        if (this.symbols == null) {
            DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.symbols = format.getDecimalFormatSymbols();
        }
        return this.symbols;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }
}

