/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.util.Arrays;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class RequiredField
implements IValidator {
    private String ignoreCharacters = "";
    private char[] sortedIgnoreCharacters = new char[0];

    public String getIgnoreCharacters() {
        return this.ignoreCharacters;
    }

    public void setIgnoreCharacters(String ignoreCharacters) {
        this.ignoreCharacters = ignoreCharacters;
        this.sortedIgnoreCharacters = ignoreCharacters == null ? new char[]{} : ignoreCharacters.toCharArray();
        Arrays.sort(this.sortedIgnoreCharacters);
    }

    public IStatus validate(Object value) {
        if (value == null) {
            return ValidationRuleStatus.error(true, "Value is null.", this);
        }
        if (!(value instanceof String)) {
            throw new ValidationFailure(String.valueOf(this.getClass().getSimpleName()) + " can only validate objects of type " + String.class.getName());
        }
        String toBeChecked = (String)value;
        int t = 0;
        while (t < toBeChecked.length()) {
            char currentChar = toBeChecked.charAt(t);
            if (!Character.isWhitespace(currentChar) && Arrays.binarySearch(this.sortedIgnoreCharacters, currentChar) < 0) {
                return ValidationRuleStatus.ok();
            }
            ++t;
        }
        return ValidationRuleStatus.error(false, "'String must not be blank.", this);
    }
}

