/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.ArraysUtil;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.validation.Utils;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class ValidDecimal
implements IValidator,
IExecutableExtension {
    private static final char FRENCH_GROUPING_SEPARATOR = '\u00a0';
    private boolean partialCheckSupported;
    private DecimalFormat format;
    private DecimalFormatSymbols symbols;
    private int numberOfFractionDigits;
    private int maxLength;
    private Locale locale;

    public ValidDecimal() {
        this(Locale.getDefault());
    }

    public ValidDecimal(Locale locale) {
        this(false, locale);
    }

    public ValidDecimal(boolean partialCheckSupported, Locale locale) {
        this(partialCheckSupported, 15, 2, false, locale);
    }

    public ValidDecimal(boolean partialCheckSupported, int numberOfFractionDigits, int maxLength, boolean withSign, Locale locale) {
        Assert.isNotNull((Object)locale);
        this.partialCheckSupported = partialCheckSupported;
        this.numberOfFractionDigits = numberOfFractionDigits;
        this.maxLength = maxLength;
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus validate(Object value) {
        if (value != null) {
            if (!(value instanceof String)) {
                throw new ValidationFailure("ValidCharacters can only validate objects of type String.");
            }
            String string = Utils.removeWhitespace((String)value);
            if (string.length() > 0) {
                ScanResult scanned = this.scan(string);
                if (!this.partialCheckSupported) {
                    if (scanned.decimalSeperatorIndex < 0) {
                        return ValidationRuleStatus.error(true, "no decimal separator '" + this.getSymbols().getDecimalSeparator() + "' in String '" + string + '\'', this);
                    }
                    if (scanned.groupingSeparatorIndex > scanned.decimalSeperatorIndex) {
                        return ValidationRuleStatus.error(true, "grouping-separator '" + this.getSymbols().getGroupingSeparator() + "' behind decimal-seperator '" + this.getSymbols().getDecimalSeparator() + "' in string '" + string + '\'', this);
                    }
                }
                if (scanned.lastAlienCharIndex > -1) {
                    return ValidationRuleStatus.error(true, "unrecognized character '" + scanned.lastAlienCharacter + "' in string '" + string + '\'', this);
                }
                try {
                    DecimalFormat decimalFormat = this.getFormat();
                    synchronized (decimalFormat) {
                        this.getFormat().parse(string);
                    }
                }
                catch (ParseException parseException) {
                    return ValidationRuleStatus.error(true, "cannot parse string '" + string + "' to number.", this);
                }
            }
        }
        return ValidationRuleStatus.ok();
    }

    protected ScanResult scan(String string) {
        ScanResult result = new ScanResult();
        boolean acceptWhitespaceAsGroupingSeperator = Character.isWhitespace(this.getSymbols().getGroupingSeparator()) || this.getSymbols().getGroupingSeparator() == '\u00a0';
        char minusSign = this.getSymbols().getMinusSign();
        int t = 0;
        while (t < string.length()) {
            char currentChar = string.charAt(t);
            if (currentChar == this.getSymbols().getDecimalSeparator()) {
                result.decimalSeperatorIndex = t;
            } else if (currentChar == this.getSymbols().getGroupingSeparator() || Character.isWhitespace(currentChar) && acceptWhitespaceAsGroupingSeperator) {
                result.groupingSeparatorIndex = t;
            } else if (currentChar == minusSign) {
                result.minusSignIndex = t;
            } else if (!Character.isDigit(currentChar)) {
                result.lastAlienCharacter = currentChar;
                result.lastAlienCharIndex = t;
            }
            ++t;
        }
        return result;
    }

    protected DecimalFormat getFormat() {
        if (this.format == null) {
            this.format = (DecimalFormat)DecimalFormat.getInstance(this.locale);
            this.format.setMaximumFractionDigits(this.numberOfFractionDigits);
            this.format.setMaximumIntegerDigits(this.maxLength);
        }
        return this.format;
    }

    protected DecimalFormatSymbols getSymbols() {
        if (this.symbols == null) {
            this.symbols = this.getFormat().getDecimalFormatSymbols();
        }
        return this.symbols;
    }

    protected void setLocal(String[] localArgs) {
        if (localArgs.length > 0) {
            String language = localArgs[0];
            String country = "";
            String variant = "";
            if (localArgs.length > 1) {
                country = localArgs[1];
            }
            if (localArgs.length > 2) {
                variant = localArgs[2];
            }
            this.setLocale(new Locale(language, country, variant));
        }
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            Object[] args = PropertiesUtils.asArray((Object)data);
            int localStart = 0;
            if (args.length > 0) {
                if (args[0].equals(Boolean.TRUE.toString())) {
                    this.partialCheckSupported = true;
                    ++localStart;
                } else if (args[0].equals(Boolean.FALSE.toString())) {
                    this.partialCheckSupported = false;
                    ++localStart;
                }
            }
            if (args.length > 1 && args[1].length() > 0) {
                try {
                    this.numberOfFractionDigits = Integer.parseInt((String)args[1]);
                    ++localStart;
                    if (args.length > 2 && ((String)args[2]).length() > 0) {
                        this.maxLength = Integer.parseInt((String)args[2]);
                        ++localStart;
                        if (args.length > 3 && ((String)args[3]).length() > 0) {
                            if (((String)args[3]).equals(Boolean.TRUE.toString())) {
                                ++localStart;
                            } else if (((String)args[3]).equals(Boolean.FALSE.toString())) {
                                ++localStart;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (args.length > localStart) {
                String[] localArgs = (String[])ArraysUtil.copyRange((Object[])args, (int)localStart, (int)args.length);
                this.setLocal(localArgs);
            }
        }
    }

    protected static final class ScanResult {
        protected int decimalSeperatorIndex = -1;
        protected int groupingSeparatorIndex = -1;
        protected int minusSignIndex = -1;
        protected char lastAlienCharacter;
        protected int lastAlienCharIndex = -1;

        private ScanResult() {
        }
    }
}

