/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ChoiceComposite
extends Composite {
    private final boolean isMulti;
    private int orientation;

    public ChoiceComposite(Composite parent, int style, boolean multipleSelection) {
        super(parent, style);
        this.isMulti = multipleSelection;
        this.orientation = 512;
        this.applyOrientation();
        this.setBackground(LnfManager.getLnf().getColor("SubModule.background"));
    }

    public int getOrientation() {
        return this.orientation;
    }

    public final boolean isMultipleSelection() {
        return this.isMulti;
    }

    public final void setBackground(Color color) {
        this.setRedraw(false);
        try {
            super.setBackground(color);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setBackground(color);
                ++n2;
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setEnabled(boolean enabled) {
        this.setRedraw(false);
        try {
            super.setEnabled(enabled);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setEnabled(enabled);
                ++n2;
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setForeground(Color color) {
        this.setRedraw(false);
        try {
            super.setForeground(color);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setForeground(color);
                ++n2;
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setOrientation(int orientation) {
        Assert.isLegal((orientation == 512 || orientation == 256 ? 1 : 0) != 0);
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.applyOrientation();
        }
    }

    private void applyOrientation() {
        if (this.orientation == 512) {
            this.setLayout((Layout)new FillLayout(512));
        } else {
            RowLayout layout = new RowLayout(256);
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.wrap = false;
            this.setLayout((Layout)layout);
        }
    }
}

