/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.riena.ui.swt.AbstractStatuslineComposite;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class StatuslineMessage
extends AbstractStatuslineComposite {
    private static final int TOP_MARGIN = 3;
    private CLabel messageLabel;

    public StatuslineMessage(Composite parent, int style) {
        super(parent, style | 0x80000);
    }

    protected void createContents() {
        this.messageLabel = new CLabel((Composite)this, 16384);
        this.messageLabel.setText(" ");
        this.messageLabel.setImage(this.getPlaceholderImage());
        this.messageLabel.setBackground(LnfManager.getLnf().getColor("statusline.background"));
    }

    public void dispose() {
        super.dispose();
        SwtUtilities.disposeWidget((Widget)this.messageLabel);
    }

    public void setImage(Image image) {
        this.messageLabel.setImage(image);
    }

    public void setMessage(String msg) {
        this.messageLabel.setText(msg);
        this.messageLabel.getParent().layout(true);
    }

    private Image getPlaceholderImage() {
        return LnfManager.getLnf().getImage("statusline.spacerIcon");
    }

    protected int getTopMargin() {
        return 3;
    }
}

