/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf;

import org.eclipse.core.runtime.Platform;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.BundleUtil;
import org.osgi.framework.Bundle;

public final class LnfManager {
    private static final String DEFAULT_LNF_CLASSNAME = RienaDefaultLnf.class.getName();
    private static String lnfClassName;
    private static RienaDefaultLnf lnf;

    private LnfManager() {
    }

    public static RienaDefaultLnf getLnf() {
        if (lnf == null) {
            String className = LnfManager.getLnfClassName();
            try {
                RienaDefaultLnf myLnf = LnfManager.createLnf(className);
                LnfManager.setLnf(myLnf);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Error("can't load " + className);
            }
        }
        lnf.initialize();
        return lnf;
    }

    public static void setLnf(String newLnfClassName) {
        LnfManager.dispose();
        lnfClassName = newLnfClassName;
    }

    private static RienaDefaultLnf createLnf(String lnfClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class lnfClass = null;
        if (lnfClassName.contains(":")) {
            String[] parts = lnfClassName.split(":");
            String pluginID = parts[0];
            String classPath = parts[1];
            Bundle bundle = Platform.getBundle((String)pluginID);
            if (!BundleUtil.isReady(bundle)) {
                return null;
            }
            lnfClass = bundle.loadClass(classPath);
        } else {
            ClassLoader classLoader = LnfManager.class.getClassLoader();
            lnfClass = classLoader.loadClass(lnfClassName);
        }
        return (RienaDefaultLnf)lnfClass.newInstance();
    }

    public static void setLnf(RienaDefaultLnf newLnf) {
        lnf = newLnf;
    }

    public static String getLnfClassName() {
        String className = lnfClassName;
        if (className == null) {
            className = DEFAULT_LNF_CLASSNAME;
        }
        return className;
    }

    public static void dispose() {
        if (lnf != null) {
            lnf.uninitialize();
            lnf = null;
        }
    }
}

