/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.lnf.renderer;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.FlasherSupportForRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.HoverBorderRenderer;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Control;

public class EmbeddedTitlebarRenderer
extends AbstractLnfRenderer {
    private static final int TITLEBAR_LABEL_PADDING_LEFT = 5;
    private static final int TITLEBAR_LABEL_PADDING = 4;
    private static final int TITLEBAR_ICON_TEXT_GAP = 4;
    private Control control;
    private Image image = null;
    private String title;
    private Color edgeColor;
    private boolean active = false;
    private boolean pressed = false;
    private boolean hover = false;
    private boolean closeable = false;
    private boolean closeButtonPressed;
    private boolean closeButtonHover;
    private FlasherSupportForRenderer flasherSupport = new FlasherSupportForRenderer(this, new MarkerUpdater());

    public void dispose() {
        SwtUtilities.disposeResource((Resource)this.getImage());
        SwtUtilities.disposeResource((Resource)this.edgeColor);
        this.control = null;
    }

    public Point computeSize(GC gc, int wHint, int hHint) {
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        int h = fontMetrics.getHeight() + 8;
        return new Point(wHint, h);
    }

    private Font getTitlebarFont() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Font font = lnf.getFont("EmbeddedTitlebar.font");
        return font;
    }

    public void paint(GC gc, Object value) {
        String text;
        Assert.isNotNull((Object)gc);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof Control));
        this.control = (Control)value;
        if (this.getBounds() == null) {
            return;
        }
        gc.setAdvanced(true);
        gc.setAntialias(0);
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Color startColor = lnf.getColor("EmbeddedTitlebar.passiveBackgroundStartColor");
        Color endColor = lnf.getColor("EmbeddedTitlebar.passiveBackgroundEndColor");
        if (this.isActive() || this.flasherSupport.isProcessMarkerVisible()) {
            startColor = lnf.getColor("EmbeddedTitlebar.activeBackgroundStartColor");
            endColor = lnf.getColor("EmbeddedTitlebar.activeBackgroundEndColor");
        }
        gc.setForeground(startColor);
        gc.setBackground(endColor);
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        int w = this.getBounds().width;
        int h = this.getBounds().height;
        if (this.isPressed() && !this.isActive() && !this.isCloseButtonPressed()) {
            gc.fillRectangle(x, y, w, h);
        } else {
            gc.fillGradientRectangle(x, y, w, h, true);
        }
        Color borderColor = lnf.getColor("EmbeddedTitlebar.passiveBorderColor");
        if (this.isActive() || this.flasherSupport.isProcessMarkerVisible()) {
            borderColor = lnf.getColor("EmbeddedTitlebar.activeBorderColor");
        } else if (!this.isEnabled()) {
            borderColor = lnf.getColor("EmbeddedTitlebar.disabledBorderColor");
        }
        gc.setForeground(borderColor);
        x = this.getBounds().x + 1;
        y = this.getBounds().y;
        w = this.getWidth() - 2;
        gc.drawLine(x, y, x + w, y);
        y = this.getBounds().y + this.getHeight();
        gc.drawLine(x, y, x + w, y);
        x = this.getBounds().x;
        y = this.getBounds().y + 1;
        h = this.getHeight() - 2;
        gc.drawLine(x, y, x, y + h);
        x = this.getBounds().x + this.getWidth();
        gc.drawLine(x, y, x, y + h);
        if (this.edgeColor == null || this.edgeColor.isDisposed()) {
            this.edgeColor = SwtUtilities.makeBrighter(borderColor, 1.15f);
        }
        gc.setForeground(this.edgeColor);
        x = this.getBounds().x;
        y = this.getBounds().y;
        gc.drawPoint(x, y);
        x = this.getBounds().x + this.getWidth();
        y = this.getBounds().y;
        gc.drawPoint(x, y);
        x = this.getBounds().x;
        y = this.getBounds().y + this.getHeight();
        gc.drawPoint(x, y);
        x = this.getBounds().x + this.getWidth();
        y = this.getBounds().y + this.getHeight();
        gc.drawPoint(x, y);
        Rectangle closeBounds = this.computeCloseButtonBounds();
        if (this.isCloseable()) {
            Image closeImage = this.getCloseButtonImage();
            gc.drawImage(closeImage, closeBounds.x, closeBounds.y);
        } else {
            closeBounds.x = 0;
            closeBounds.y = 0;
            closeBounds.width = 0;
            closeBounds.height = 0;
        }
        x = this.getBounds().x + 5;
        if (this.getImage() != null) {
            y = this.getBounds().y + (this.getHeight() - this.getImage().getImageData().height) / 2;
            gc.drawImage(this.getImage(), x, y);
            x += this.getImage().getImageData().width + 4;
        }
        if (!StringUtils.isEmpty((CharSequence)(text = this.getTitle()))) {
            gc.setForeground(lnf.getColor("EmbeddedTitlebar.foreground"));
            if (!this.isEnabled()) {
                gc.setForeground(lnf.getColor("EmbeddedTitlebar.disabledForeground"));
            }
            int y2 = (this.getHeight() - gc.getFontMetrics().getHeight()) / 2;
            y = this.getBounds().y + y2;
            text = this.getClippedText(gc, text);
            gc.drawText(text, x, y, true);
        }
        if (this.isHover() && (!this.isPressed() || this.isActive())) {
            x = this.getBounds().x;
            y = this.getBounds().y;
            w = this.getBounds().width;
            h = this.getHeight();
            this.getHoverBorderRenderer().setBounds(x, y, w, h);
            this.getHoverBorderRenderer().paint(gc, null);
        }
        this.flasherSupport.startFlasher();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean isHover() {
        return this.hover;
    }

    public void setHover(boolean hover) {
        this.hover = hover;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    private int getHeight() {
        return this.getBounds().height - 1;
    }

    private int getWidth() {
        return this.getBounds().width - 1;
    }

    protected HoverBorderRenderer getHoverBorderRenderer() {
        return (HoverBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.hoverBorderRenderer");
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    private Rectangle computeCloseButtonBounds() {
        Rectangle closeBounds = new Rectangle(0, 0, 0, 0);
        Image closeImage = this.getCloseButtonImage();
        if (closeImage == null) {
            return closeBounds;
        }
        closeBounds.width = closeImage.getImageData().width;
        closeBounds.height = closeImage.getImageData().height;
        closeBounds.x = this.getBounds().x + this.getWidth() - closeBounds.width - 4;
        closeBounds.y = this.getBounds().y + (this.getHeight() - closeBounds.height) / 2;
        return closeBounds;
    }

    public boolean isInsideCloseButton(Point pt) {
        Rectangle closeBounds = this.computeCloseButtonBounds();
        return closeBounds.contains(pt);
    }

    private Image getCloseButtonImage() {
        RienaDefaultLnf lnf = LnfManager.getLnf();
        String key = "EmbeddedTitlebar.closeIcon";
        if (this.isEnabled()) {
            if (this.isCloseButtonPressed()) {
                key = "EmbeddedTitlebar.closeHoverSelectedIcon";
            } else if (this.isCloseButtonHover()) {
                key = "EmbeddedTitlebar.closeHoverIcon";
            }
        } else {
            key = "EmbeddedTitlebar.closeInactiveIcon";
        }
        Image closeImage = lnf.getImage(key);
        return closeImage;
    }

    public boolean isCloseButtonPressed() {
        return this.closeButtonPressed;
    }

    public void setCloseButtonPressed(boolean pressed) {
        this.closeButtonPressed = pressed;
    }

    public boolean isCloseButtonHover() {
        return this.closeButtonHover;
    }

    public void setCloseButtonHover(boolean hover) {
        this.closeButtonHover = hover;
    }

    public Rectangle computeTextBounds(GC gc) {
        Rectangle textBounds = new Rectangle(0, 0, 0, 0);
        textBounds.x = this.getBounds().x + 5;
        if (this.getImage() != null) {
            textBounds.x += this.getImage().getImageData().width + 4;
        }
        textBounds.width = this.getWidth() - (textBounds.x - this.getBounds().x) - 4;
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        FontMetrics fontMetrics = gc.getFontMetrics();
        textBounds.height = fontMetrics.getHeight();
        textBounds.y = this.getBounds().y + (this.getBounds().height - textBounds.height) / 2;
        return textBounds;
    }

    public String getClippedText(GC gc, String text) {
        Rectangle textBounds = this.computeTextBounds(gc);
        int maxWidth = textBounds.width;
        if (this.isCloseable()) {
            Rectangle closeBounds = this.computeCloseButtonBounds();
            maxWidth -= closeBounds.width;
        }
        Font font = this.getTitlebarFont();
        gc.setFont(font);
        return SwtUtilities.clipText(gc, text, maxWidth);
    }

    private class MarkerUpdater
    implements Runnable {
        private MarkerUpdater() {
        }

        public void run() {
            if (EmbeddedTitlebarRenderer.this.control != null) {
                EmbeddedTitlebarRenderer.this.control.redraw();
            }
        }
    }
}

