/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.uiprocess;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.window.Window;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.uiprocess.ICancelListener;
import org.eclipse.riena.ui.swt.uiprocess.IProcessWindowListener;
import org.eclipse.riena.ui.swt.uiprocess.IProgressControl;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessWindow;
import org.eclipse.riena.ui.swt.utils.IPropertyNameProvider;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class UIProcessControl
implements IProgressControl,
IPropertyNameProvider {
    private static final int UPDATE_DELAY = 200;
    private boolean processing;
    private UIProcessWindow processWindow;
    private ListenerList<ICancelListener> cancelListeners = new ListenerList(ICancelListener.class);
    private ProcessUpdateThread processUpdateThread;
    private String name;

    public UIProcessControl(Shell parentShell) {
        Assert.isNotNull((Object)parentShell);
        this.createProcessWindow(parentShell);
    }

    private void createProcessWindow(Shell parentShell) {
        this.processWindow = new UIProcessWindow(parentShell, this);
        this.processWindow.addProcessWindowListener(new IProcessWindowListener(){

            public void windowAboutToClose() {
                UIProcessControl.this.stopProcessing();
                UIProcessControl.this.fireCanceled(true);
            }
        });
    }

    public Window getWindow() {
        return this.processWindow;
    }

    private void showWindow() {
        this.processWindow.openWindow();
    }

    public void stop() {
        this.closeWindow();
    }

    private void closeWindow() {
        this.stopProcessing();
        this.processWindow.closeWindow();
    }

    protected synchronized boolean isProcessing() {
        return this.processing;
    }

    public synchronized void setProcessing(boolean processing) {
        this.processing = processing;
    }

    public void showProcessing() {
        this.startProcessing();
    }

    private void startProcessing() {
        if (!this.isProcessing()) {
            this.setProcessing(true);
            this.getProgressBar().setMaximum(90);
            this.getPercentLabel().setText("");
            if (this.processUpdateThread == null || !this.processUpdateThread.isAlive()) {
                this.startUpdateThread();
            }
        }
    }

    private void startUpdateThread() {
        this.processUpdateThread = new ProcessUpdateThread();
        this.processUpdateThread.start();
    }

    private void processUpdateLoop() {
        final int[] selection = new int[1];
        while (this.isProcessing()) {
            selection[0] = selection[0] <= 100 ? selection[0] + 10 : 0;
            if (!this.getProgressBar().isDisposed()) {
                this.getProgressBar().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!UIProcessControl.this.getProgressBar().isDisposed() && UIProcessControl.this.isProcessing()) {
                            UIProcessControl.this.getProgressBar().setSelection(selection[0]);
                        }
                    }
                });
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private ProgressBar getProgressBar() {
        return this.processWindow.getProgressBar();
    }

    public void showProgress(int value, int maxValue) {
        this.stopProcessing();
        int percentValue = this.calcSelection(value, maxValue);
        if (this.getWindow().getShell() != null && !this.getWindow().getShell().isDisposed()) {
            this.getPercentLabel().setText(String.valueOf(String.valueOf(percentValue)) + " %");
            this.getProgressBar().setSelection(percentValue);
        }
    }

    private Label getPercentLabel() {
        return this.processWindow.getPercent();
    }

    private int calcSelection(int value, int maxValue) {
        double v = (double)value / (double)maxValue * 100.0;
        return (int)v;
    }

    private void stopProcessing() {
        this.setProcessing(false);
    }

    public void start() {
        this.showWindow();
    }

    public void setDescription(String text) {
        this.processWindow.setDescription(text);
    }

    public void setTitle(String text) {
        Shell shell = this.processWindow.getShell();
        if (!StringUtils.equals((CharSequence)text, (CharSequence)shell.getText())) {
            shell.setText(text);
            Rectangle bounds = shell.getBounds();
            shell.redraw(0, 0, bounds.width, bounds.height, true);
        }
    }

    public void addCancelListener(ICancelListener listener) {
        this.cancelListeners.add((Object)listener);
    }

    public void removeCancelListener(ICancelListener listener) {
        this.cancelListeners.remove((Object)listener);
    }

    protected void fireCanceled(boolean windowClosing) {
        ICancelListener[] iCancelListenerArray = (ICancelListener[])this.cancelListeners.getListeners();
        int n = iCancelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICancelListener listener = iCancelListenerArray[n2];
            listener.canceled(windowClosing);
            ++n2;
        }
    }

    public String getPropertyName() {
        return this.name;
    }

    public void setPropertyName(String propertyName) {
        this.name = propertyName;
    }

    private final class ProcessUpdateThread
    extends Thread {
        private ProcessUpdateThread() {
        }

        public void run() {
            this.setPriority(10);
            this.setName("ProcessUpdateThread");
            UIProcessControl.this.processUpdateLoop();
        }
    }
}

