/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class ImageUtil {
    private ImageUtil() {
    }

    public static Image getImage(String fullPath) {
        if (StringUtils.isEmpty((CharSequence)fullPath)) {
            return null;
        }
        if (Activator.getDefault() == null) {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(fullPath);
        if (image == null || image.isDisposed()) {
            ImageDescriptor descriptor = null;
            String[] parts = fullPath.split(":");
            if (parts.length < 2) {
                return null;
            }
            String pluginID = parts[0];
            String iconPath = parts[1];
            descriptor = Activator.imageDescriptorFromPlugin((String)pluginID, (String)iconPath);
            if (descriptor == null) {
                return null;
            }
            image = descriptor.createImage();
            imageRegistry.remove(fullPath);
            imageRegistry.put(fullPath, descriptor);
        }
        return image;
    }

    public static String getImagePath(Bundle bundle, String subPath) {
        if (bundle == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(bundle.getSymbolicName());
        builder.append(":");
        builder.append(subPath);
        return builder.toString();
    }
}

