/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Widget;

public final class SwtUtilities {
    private SwtUtilities() {
        throw new Error("SwtUtilities is just a container for static methods");
    }

    public static String clipText(GC gc, String text, int maxWidth) {
        int textwidth = SwtUtilities.calcTextWidth(gc, text);
        if (textwidth > maxWidth) {
            StringBuffer shortText = new StringBuffer(text);
            shortText.append("...");
            while (textwidth > maxWidth) {
                if (shortText.length() <= 3) break;
                shortText = shortText.deleteCharAt(shortText.length() - 4);
                textwidth = SwtUtilities.calcTextWidth(gc, shortText);
            }
            return shortText.toString();
        }
        return text;
    }

    public static int calcTextWidth(GC gc, String text) {
        return SwtUtilities.calcTextWidth(gc, new StringBuffer(text));
    }

    public static int calcTextWidth(GC gc, StringBuffer text) {
        int width = 0;
        if (text == null) {
            return width;
        }
        int i = 0;
        while (i < text.length()) {
            width += gc.getAdvanceWidth(text.charAt(i));
            ++i;
        }
        return width;
    }

    public static Color makeBrighter(Color color, float f) {
        assert (color != null);
        assert ((double)f >= 0.0);
        float[] hsb = color.getRGB().getHSB();
        float h = hsb[0];
        float s = hsb[1];
        float b = hsb[2];
        if ((b *= f) > 1.0f) {
            b = 1.0f;
        }
        RGB rgb = new RGB(h, s, b);
        return new Color(color.getDevice(), rgb);
    }

    public static void disposeResource(Resource resource) {
        if (!SwtUtilities.isDisposed(resource)) {
            resource.dispose();
        }
        resource = null;
    }

    public static void disposeWidget(Widget widget) {
        if (!SwtUtilities.isDisposed(widget)) {
            widget.dispose();
        }
        widget = null;
    }

    public static boolean isDisposed(Widget widget) {
        return widget == null || widget.isDisposed();
    }

    public static boolean isDisposed(Resource resource) {
        return resource == null || resource.isDisposed();
    }
}

