/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.workarea.registry;

import java.util.Hashtable;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.riena.internal.ui.workarea.Activator;
import org.eclipse.riena.internal.ui.workarea.registry.ExplicitWorkareaDefinitionRegistry;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaDefinition;
import org.eclipse.riena.ui.workarea.spi.IWorkareaDefinitionRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkareaDefinitionRegistryFacade
implements IWorkareaDefinitionRegistry,
ServiceTrackerCustomizer {
    private static final WorkareaDefinitionRegistryFacade INSTANCE = new WorkareaDefinitionRegistryFacade();
    private SortedSet<WorkareaDefinitionRegistryWithRank> contributedRegistries = new TreeSet<WorkareaDefinitionRegistryWithRank>();

    public static WorkareaDefinitionRegistryFacade getInstance() {
        return INSTANCE;
    }

    private WorkareaDefinitionRegistryFacade() {
        this.registerExplicitDefinitionRegistry();
    }

    @Override
    public IWorkareaDefinition getDefinition(Object id) {
        for (IWorkareaDefinitionRegistry iWorkareaDefinitionRegistry : this.contributedRegistries) {
            INavigationNode node;
            IWorkareaDefinition definition = iWorkareaDefinitionRegistry.getDefinition(id);
            if (definition != null) {
                return definition;
            }
            if (!(id instanceof INavigationNode) || (node = (INavigationNode)id).getNodeId() == null || node.getNodeId().getTypeId() == null || (definition = iWorkareaDefinitionRegistry.getDefinition(node.getNodeId().getTypeId())) == null) continue;
            return definition;
        }
        return null;
    }

    public IWorkareaDefinition registerDefinition(Object id, Class<? extends IController> controllerClass, Object viewId, boolean isViewShared) {
        return this.register(id, new WorkareaDefinition(controllerClass, viewId, isViewShared));
    }

    @Override
    public IWorkareaDefinition register(Object id, IWorkareaDefinition definition) {
        for (IWorkareaDefinitionRegistry iWorkareaDefinitionRegistry : this.contributedRegistries) {
            IWorkareaDefinition def = iWorkareaDefinitionRegistry.register(id, definition);
            if (def == null) continue;
            return def;
        }
        return null;
    }

    private void registerExplicitDefinitionRegistry() {
        BundleContext context = Activator.getDefault().getBundle().getBundleContext();
        ExplicitWorkareaDefinitionRegistry registry = ExplicitWorkareaDefinitionRegistry.getInstance();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>();
        props.put("service.ranking", 100);
        context.registerService(IWorkareaDefinitionRegistry.class.getName(), (Object)registry, props);
    }

    public Object addingService(ServiceReference reference) {
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IWorkareaDefinitionRegistry registry = (IWorkareaDefinitionRegistry)bundleContext.getService(reference);
        this.contributedRegistries.add(this.createEntry(reference, registry));
        return registry;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        WorkareaDefinitionRegistryWithRank entry = this.createEntry(reference, service);
        this.contributedRegistries.remove(entry);
        this.contributedRegistries.add(entry);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.contributedRegistries.remove(this.createEntry(reference, service));
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        bundleContext.ungetService(reference);
    }

    private WorkareaDefinitionRegistryWithRank createEntry(ServiceReference reference, Object registry) {
        Object rankingProperty = reference.getProperty("service.ranking");
        int ranking = rankingProperty instanceof Integer ? (Integer)rankingProperty : 0;
        return new WorkareaDefinitionRegistryWithRank(ranking, (IWorkareaDefinitionRegistry)registry);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkareaDefinitionRegistryWithRank
    implements IWorkareaDefinitionRegistry,
    Comparable<WorkareaDefinitionRegistryWithRank> {
        private int ranking;
        private IWorkareaDefinitionRegistry registry;

        WorkareaDefinitionRegistryWithRank(int ranking, IWorkareaDefinitionRegistry registry) {
            this.ranking = ranking;
            this.registry = registry;
        }

        public int getRanking() {
            return this.ranking;
        }

        public IWorkareaDefinitionRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public IWorkareaDefinition getDefinition(Object id) {
            return this.registry.getDefinition(id);
        }

        @Override
        public IWorkareaDefinition register(Object id, IWorkareaDefinition definition) {
            return this.registry.register(id, definition);
        }

        @Override
        public int compareTo(WorkareaDefinitionRegistryWithRank other) {
            if (this.getRanking() != other.getRanking()) {
                return this.getRanking() > other.getRanking() ? -1 : 1;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other instanceof WorkareaDefinitionRegistryWithRank) {
                return this.registry.equals(((WorkareaDefinitionRegistryWithRank)other).getRegistry());
            }
            return this.registry.equals(other);
        }

        public int hashCode() {
            return this.registry.hashCode();
        }
    }
}

