/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable.day;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.swt.nebula.widgets.compositetable.RowConstructionListener;
import org.eclipse.swt.nebula.widgets.compositetable.ScrollEvent;
import org.eclipse.swt.nebula.widgets.compositetable.ScrollListener;
import org.eclipse.swt.nebula.widgets.compositetable.day.CalendarableItemEvent;
import org.eclipse.swt.nebula.widgets.compositetable.day.CalendarableItemEventHandler;
import org.eclipse.swt.nebula.widgets.compositetable.day.CalendarableSelectionChangeListener;
import org.eclipse.swt.nebula.widgets.compositetable.day.DayEditorSelection;
import org.eclipse.swt.nebula.widgets.compositetable.day.ICalendarableItemControl;
import org.eclipse.swt.nebula.widgets.compositetable.day.SelectionChangeEvent;
import org.eclipse.swt.nebula.widgets.compositetable.day.internal.DayEditorCalendarableItemControl;
import org.eclipse.swt.nebula.widgets.compositetable.day.internal.EventLayoutComputer;
import org.eclipse.swt.nebula.widgets.compositetable.day.internal.TimeSlice;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.AbstractEventEditor;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.CalendarableItem;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.CalendarableModel;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.EventContentProvider;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.EventCountProvider;
import org.eclipse.swt.nebula.widgets.compositetable.timeeditor.IEventEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class DayEditor
extends AbstractEventEditor
implements IEventEditor {
    private CompositeTable compositeTable = null;
    private CalendarableModel model = new CalendarableModel();
    private List recycledCalendarableEventControls = new LinkedList();
    protected TimeSlice daysHeader = null;
    private final boolean headerDisabled;
    public static final int NO_HEADER = 8;
    private Menu menu = null;
    private ArrayList keyListeners = new ArrayList();
    private KeyListener keyListener = new KeyAdapter(){

        public void keyReleased(KeyEvent e) {
            for (KeyListener keyListener : DayEditor.this.keyListeners) {
                keyListener.keyReleased(e);
                if (e.doit) continue;
                return;
            }
        }

        public void keyPressed(KeyEvent e) {
            int selectedDay;
            int selectedRow;
            for (KeyListener keyListener : DayEditor.this.keyListeners) {
                keyListener.keyPressed(e);
                if (e.doit) continue;
                return;
            }
            CalendarableItem selection = DayEditor.this.selectedCalendarable;
            boolean allDayEventRowSelected = false;
            int compositeTableRow = ((DayEditor)DayEditor.this).compositeTable.getSelection().y + DayEditor.this.compositeTable.getTopRow();
            if (compositeTableRow < DayEditor.this.numberOfAllDayEventRows) {
                allDayEventRowSelected = true;
            }
            if (selection == null) {
                selectedRow = DayEditor.this.convertViewportRowToDayRow(DayEditor.this.compositeTable.getCurrentRow());
                selectedDay = DayEditor.this.compositeTable.getCurrentColumn();
            } else {
                selectedDay = DayEditor.this.model.getDay(selection);
                if (allDayEventRowSelected) {
                    selectedRow = compositeTableRow;
                } else {
                    Point selectedCoordinates = selection.getUpperLeftPositionInDayRowCoordinates();
                    if (selectedCoordinates == null) {
                        return;
                    }
                    selectedRow = selectedCoordinates.y;
                }
            }
            switch (e.character) {
                case '\t': {
                    CalendarableItem newSelection;
                    if ((e.stateMask & 0x20000) != 0) {
                        newSelection = DayEditor.this.model.findPreviousCalendarable(selectedDay, selectedRow, selection, allDayEventRowSelected);
                        if (newSelection == null) {
                            return;
                        }
                        int newTopRow = DayEditor.this.computeNewTopRowBasedOnSelection(newSelection);
                        if (newTopRow != DayEditor.this.compositeTable.getTopRow()) {
                            DayEditor.this.compositeTable.setTopRow(newTopRow);
                        }
                        DayEditor.this.setSelection(newSelection);
                        break;
                    }
                    newSelection = DayEditor.this.model.findNextCalendarable(selectedDay, selectedRow, selection, allDayEventRowSelected);
                    if (newSelection == null) {
                        return;
                    }
                    int newTopRow = DayEditor.this.computeNewTopRowBasedOnSelection(newSelection);
                    if (newTopRow != DayEditor.this.compositeTable.getTopRow()) {
                        DayEditor.this.compositeTable.setTopRow(newTopRow);
                    }
                    DayEditor.this.setSelection(newSelection);
                }
            }
        }
    };
    private ArrayList mouseListeners = new ArrayList();
    private MouseListener cellMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
            DayEditor.this.fireMouseDoubleClickEvent(e);
        }

        public void mouseDown(MouseEvent e) {
            DayEditor.this.fireMouseDownEvent(e);
        }

        public void mouseUp(MouseEvent e) {
            DayEditor.this.fireMouseUpEvent(e);
        }
    };
    private boolean selectCalendarableControlOnSetFocus = true;
    private FocusListener cellFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            TimeSlice sendingRow = (TimeSlice)((Composite)e.widget).getParent();
            int day = sendingRow.getControlColumn(e.widget);
            int row = DayEditor.this.compositeTable.getControlRow((Control)sendingRow);
            if (DayEditor.this.selectCalendarableControlOnSetFocus) {
                DayEditor.this.setSelectionByDayAndRow(day, row, null);
            } else {
                DayEditor.this.selectCalendarableControlOnSetFocus = true;
            }
        }
    };
    private CalendarableItem selectedCalendarable = null;
    private List selectionChangeListeners = new ArrayList();
    private List editHandlers = new ArrayList();
    private List deleteHandlers = new ArrayList();
    private List itemDisposeHandlers = new ArrayList();
    private boolean refreshing = false;
    private int numberOfAllDayEventRows = 0;
    Calendar calendar = new GregorianCalendar();
    private Runnable refreshEventControlPositions = new Runnable(){

        public void run() {
            if (DayEditor.this.isDisposed()) {
                return;
            }
            Control[] gridRows = DayEditor.this.compositeTable.getRowControls();
            int day = 0;
            while (day < DayEditor.this.model.getNumberOfDays()) {
                int columnsWithinDay = DayEditor.this.model.getNumberOfColumnsWithinDay(day);
                Point[] columnPositions = DayEditor.this.computeColumns(day, columnsWithinDay, gridRows);
                int allDayEventRow = 0;
                for (CalendarableItem calendarable : DayEditor.this.model.getCalendarableItems(day)) {
                    if (calendarable.isAllDayEvent()) {
                        DayEditor.this.layoutAllDayEvent(day, allDayEventRow, calendarable, gridRows);
                        ++allDayEventRow;
                        continue;
                    }
                    DayEditor.this.layoutTimedEvent(day, columnPositions, calendarable, gridRows);
                }
                ++day;
            }
        }
    };
    MouseAdapter selectCompositeTableOnMouseDownAdapter = new MouseAdapter(){

        public void mouseDown(MouseEvent e) {
            DayEditor.this.fireMouseDownEvent(e);
            ICalendarableItemControl control = (ICalendarableItemControl)e.widget;
            CalendarableItem aboutToSelect = control.getCalendarableItem();
            DayEditor.this.setSelection(aboutToSelect);
        }

        public void mouseDoubleClick(MouseEvent e) {
            DayEditor.this.fireMouseDoubleClickEvent(e);
        }

        public void mouseUp(MouseEvent e) {
            DayEditor.this.fireMouseUpEvent(e);
        }
    };
    private Color background = null;

    public DayEditor(Composite parent, int style) {
        super(parent, 0);
        this.headerDisabled = (style & 8) != 0;
        this.setBackground(Display.getCurrent().getSystemColor(22));
    }

    public void setTimeBreakdown(int numberOfDays, int numberOfDivisionsInHour) {
        this.checkWidget();
        this.model.setTimeBreakdown(numberOfDays, numberOfDivisionsInHour);
        if (this.compositeTable != null) {
            this.compositeTable.dispose();
        }
        this.createCompositeTable(numberOfDays, numberOfDivisionsInHour);
    }

    private void createCompositeTable(final int numberOfDays, int numberOfDivisionsInHour) {
        this.compositeTable = new CompositeTable(this, 0);
        if (this.background != null) {
            this.compositeTable.setBackground(this.background);
        }
        this.compositeTable.setTraverseOnTabsEnabled(false);
        if (!this.headerDisabled) {
            new TimeSlice((Composite)this.compositeTable, 2048);
        }
        new TimeSlice((Composite)this.compositeTable, 0);
        this.compositeTable.setNumRowsInCollection(this.computeNumRowsInCollection(numberOfDivisionsInHour));
        this.compositeTable.addRowConstructionListener(new RowConstructionListener(){

            public void headerConstructed(Control newHeader) {
                DayEditor.this.daysHeader = (TimeSlice)newHeader;
                DayEditor.this.daysHeader.setHeaderControl(true);
                DayEditor.this.daysHeader.setNumberOfColumns(numberOfDays);
                if (DayEditor.this.model.getStartDate() == null) {
                    return;
                }
                DayEditor.this.refreshColumnHeaders(DayEditor.this.daysHeader.getColumns());
            }

            public void rowConstructed(Control newRow) {
                TimeSlice timeSlice = (TimeSlice)newRow;
                timeSlice.setNumberOfColumns(numberOfDays);
                timeSlice.addCellFocusListener(DayEditor.this.cellFocusListener);
                timeSlice.addKeyListener(DayEditor.this.keyListener);
                timeSlice.addMouseListener(DayEditor.this.cellMouseListener);
            }
        });
        this.compositeTable.addRowContentProvider(new IRowContentProvider(){

            public void refresh(CompositeTable sender, int currentObjectOffset, Control row) {
                TimeSlice timeSlice = (TimeSlice)row;
                DayEditor.this.refreshRow(currentObjectOffset, timeSlice);
            }
        });
        this.compositeTable.addScrollListener(new ScrollListener(){

            public void tableScrolled(ScrollEvent scrollEvent) {
                DayEditor.this.layoutEventControls();
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle bounds = DayEditor.this.getBounds();
                DayEditor.this.compositeTable.setBounds(0, 0, bounds.width, bounds.height);
                DayEditor.this.layoutEventControlsDeferred();
            }
        });
        this.compositeTable.setRunTime(true);
    }

    public void setMenu(final Menu menu) {
        this.checkWidget();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (DayEditor.this.isDisposed()) {
                    return;
                }
                DayEditor.super.setMenu(menu);
                DayEditor.this.menu = menu;
                DayEditor.this.compositeTable.setMenu(menu);
                DayEditor.this.setMenuOnCollection(DayEditor.this.recycledCalendarableEventControls, menu);
                int day = 0;
                while (day < DayEditor.this.model.getNumberOfDays()) {
                    List calendarablesForDay = DayEditor.this.model.getCalendarableItems(day);
                    DayEditor.this.setMenuOnCollection(calendarablesForDay, menu);
                    ++day;
                }
            }
        });
    }

    private void setMenuOnCollection(List collection, Menu menu) {
        for (ICalendarableItemControl control : collection) {
            control.setMenu(menu);
        }
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        this.keyListeners.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        this.keyListeners.remove(listener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        this.mouseListeners.add(listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        this.mouseListeners.remove(listener);
    }

    protected void fireMouseDownEvent(MouseEvent e) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseDown(e);
        }
    }

    protected void fireMouseUpEvent(MouseEvent e) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseUp(e);
        }
    }

    protected void fireMouseDoubleClickEvent(MouseEvent e) {
        for (MouseListener mouseListener : this.mouseListeners) {
            mouseListener.mouseDoubleClick(e);
        }
    }

    private int computeNewTopRowBasedOnSelection(CalendarableItem newSelection) {
        int topRow = this.compositeTable.getTopRow();
        int numberOfRowsInDisplay = this.compositeTable.getNumRowsVisible();
        int newTopRow = topRow;
        Point endRowPoint = newSelection.getLowerRightPositionInDayRowCoordinates();
        if (endRowPoint != null) {
            int endRow = this.convertDayRowToViewportCoordinates(endRowPoint.y);
            if (endRow >= newTopRow + numberOfRowsInDisplay) {
                newTopRow += endRow - (newTopRow + numberOfRowsInDisplay) + 1;
            }
            int startRow = newSelection.getUpperLeftPositionInDayRowCoordinates().y;
            if ((startRow = this.convertDayRowToViewportCoordinates(startRow)) < newTopRow) {
                newTopRow = startRow;
            }
        }
        return newTopRow;
    }

    private void setSelectionByDayAndRow(int day, int row, CalendarableItem aboutToSelect) {
        int dayRow = this.convertViewportRowToDayRow(row);
        if (aboutToSelect == null && dayRow >= 0) {
            aboutToSelect = this.getFirstCalendarableAt(day, dayRow);
        }
        if (aboutToSelect == null || dayRow < 0) {
            aboutToSelect = this.getAllDayCalendarableAt(day, row + this.compositeTable.getTopRow());
        }
        this.selectCalenderableControl(aboutToSelect);
        aboutToSelect = null;
    }

    protected CalendarableItem getFirstCalendarableAt(int day, int row) {
        CalendarableItem[][] eventLayout = this.model.getEventLayout(day);
        CalendarableItem selectedCalendarable = null;
        int column = 0;
        while (column < eventLayout.length) {
            CalendarableItem calendarable = eventLayout[column][row];
            if (calendarable != null) {
                if (selectedCalendarable == null) {
                    selectedCalendarable = calendarable;
                } else if (calendarable.getStartTime().after(selectedCalendarable.getStartTime())) {
                    selectedCalendarable = calendarable;
                }
            }
            ++column;
        }
        return selectedCalendarable;
    }

    protected CalendarableItem getAllDayCalendarableAt(int day, int row) {
        CalendarableItem[] allDayEvents = this.model.getAllDayCalendarables(day);
        int allDayEventRow = 0;
        while (allDayEventRow < allDayEvents.length) {
            CalendarableItem candidate = allDayEvents[allDayEventRow];
            if (allDayEventRow == row) {
                return candidate;
            }
            ++allDayEventRow;
        }
        return null;
    }

    public void setSelection(CalendarableItem newSelection) {
        this.checkWidget();
        if (newSelection != null) {
            int day = this.model.getDay(newSelection);
            int row = this.computeRowForCalendarable(newSelection, day);
            this.selectCalendarableControlOnSetFocus = false;
            this.compositeTable.setSelection(day, row);
            this.selectCalenderableControl(newSelection);
        } else {
            this.selectCalenderableControl(null);
        }
    }

    private void selectCalenderableControl(CalendarableItem newSelection) {
        if (this.selectedCalendarable == newSelection) {
            return;
        }
        if (this.selectedCalendarable != null && this.selectedCalendarable.getControl() != null) {
            this.selectedCalendarable.getControl().setSelected(false);
        }
        CalendarableItem oldSelection = this.selectedCalendarable;
        this.selectedCalendarable = newSelection;
        if (newSelection != null && newSelection.getControl() != null) {
            newSelection.getControl().setSelected(true);
        }
        this.fireSelectionChangeEvent(oldSelection, newSelection);
    }

    public DayEditorSelection getSelection() {
        this.checkWidget();
        DayEditorSelection selection = new DayEditorSelection();
        Point compositeTableSelection = this.compositeTable.getSelection();
        int visibleAllDayEventRows = this.model.computeNumberOfAllDayEventRows();
        visibleAllDayEventRows -= this.compositeTable.getTopRow();
        if (this.selectedCalendarable != null) {
            selection.setSelectedCalendarable(this.selectedCalendarable);
            if (this.selectedCalendarable.isAllDayEvent()) {
                selection.setAllDay(true);
            }
        } else if (visibleAllDayEventRows > 0 && compositeTableSelection.y < visibleAllDayEventRows) {
            selection.setAllDay(true);
        }
        selection.setDateTime(this.computeDateTimeFromViewportCoordinates(compositeTableSelection, visibleAllDayEventRows));
        return selection;
    }

    private void fireSelectionChangeEvent(CalendarableItem currentSelection, CalendarableItem newSelection) {
        SelectionChangeEvent sce = new SelectionChangeEvent(currentSelection, newSelection);
        for (CalendarableSelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(sce);
        }
    }

    public void addSelectionChangeListener(CalendarableSelectionChangeListener l) {
        this.checkWidget();
        if (l == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.selectionChangeListeners.add(l);
    }

    private boolean fireEvents(CalendarableItem calendarableItem, List handlers) {
        CalendarableItemEvent e = new CalendarableItemEvent();
        e.calendarableItem = calendarableItem;
        for (CalendarableItemEventHandler handler : handlers) {
            handler.handleRequest(e);
            if (!e.doit) break;
        }
        for (CalendarableItemEventHandler h : handlers) {
            h.requestHandled(e);
            if (!e.doit) break;
        }
        return e.doit;
    }

    public boolean fireEdit(CalendarableItem toEdit) {
        this.checkWidget();
        CalendarableItemEvent e = new CalendarableItemEvent();
        e.calendarableItem = toEdit;
        boolean changed = this.fireEvents(e, this.editHandlers);
        if (changed) {
            this.refresh();
        }
        return changed;
    }

    public void addItemEditHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.editHandlers.add(handler);
    }

    public void removeItemEditHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.editHandlers.remove(handler);
    }

    public boolean fireDelete(CalendarableItem item) {
        this.checkWidget();
        boolean result = this.fireEvents(item, this.deleteHandlers);
        if (result) {
            this.refresh();
        }
        return result;
    }

    public void addItemDeleteHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.deleteHandlers.add(handler);
    }

    public void removeItemDeleteHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        this.deleteHandlers.remove(handler);
    }

    private boolean fireDisposeItemStrategy(CalendarableItem item) {
        return this.fireEvents(item, this.itemDisposeHandlers);
    }

    public void addItemDisposeHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        if (handler == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.itemDisposeHandlers.add(handler);
    }

    public void removeItemDisposeHandler(CalendarableItemEventHandler handler) {
        this.checkWidget();
        this.itemDisposeHandlers.remove(handler);
    }

    public void removeSelectionChangeListener(CalendarableSelectionChangeListener l) {
        this.checkWidget();
        if (l == null) {
            throw new IllegalArgumentException("The argument cannot be null");
        }
        if (this.isDisposed()) {
            throw new SWTException("Widget is disposed");
        }
        this.selectionChangeListeners.remove(l);
    }

    public int getDefaultStartHour() {
        return this.model.getDefaultStartHour();
    }

    public void setDefaultStartHour(int defaultStartHour) {
        this.checkWidget();
        this.model.setDefaultStartHour(defaultStartHour);
        this.updateVisibleRows();
        this.layoutEventControls();
    }

    public void setEventCountProvider(EventCountProvider eventCountProvider) {
        this.checkWidget();
        this.model.setEventCountProvider(eventCountProvider);
        this.updateVisibleRows();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (DayEditor.this.isDisposed()) {
                    return;
                }
                DayEditor.this.layoutEventControls();
            }
        });
    }

    public void setEventContentProvider(EventContentProvider eventContentProvider) {
        this.checkWidget();
        this.model.setEventContentProvider(eventContentProvider);
        this.updateVisibleRows();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (DayEditor.this.isDisposed()) {
                    return;
                }
                DayEditor.this.layoutEventControls();
            }
        });
    }

    public void setStartDate(Date startDate) {
        this.checkWidget();
        List removedDays = this.model.setStartDate(startDate);
        this.computeEventRowsForNewDays();
        if (this.daysHeader != null) {
            this.refreshColumnHeaders(this.daysHeader.getColumns());
        }
        this.updateVisibleRows();
        this.freeObsoleteCalendarableEventControls(removedDays);
        if (this.compositeTable.getNumRowsVisible() > 0) {
            this.layoutEventControls();
        }
    }

    public Date getStartDate() {
        this.checkWidget();
        return this.model.getStartDate();
    }

    public void refresh(Date date) {
        this.checkWidget();
        this.computeLayoutFor(date);
        this.layoutEventControls();
    }

    private void computeLayoutFor(Date date) {
        List removedDays = this.model.refresh(date);
        this.freeObsoleteCalendarableEventControls(removedDays);
        this.updateVisibleRows();
        this.computeEventRowsForDate(date);
    }

    public void refresh() {
        this.checkWidget();
        if (!this.refreshing) {
            this.refreshing = true;
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (DayEditor.this.isDisposed()) {
                        return;
                    }
                    Date dateToRefresh = DayEditor.this.getStartDate();
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(dateToRefresh);
                    int i = 0;
                    while (i < DayEditor.this.getNumberOfDays()) {
                        DayEditor.this.computeLayoutFor(gc.getTime());
                        gc.add(5, 1);
                        ++i;
                    }
                    DayEditor.this.layoutEventControls();
                    DayEditor.this.refreshing = false;
                }
            });
        }
    }

    public int getNumberOfDays() {
        this.checkWidget();
        return this.model.getNumberOfDays();
    }

    public int getNumberOfDivisionsInHour() {
        this.checkWidget();
        return this.model.getNumberOfDivisionsInHour();
    }

    private int computeNumRowsInCollection(int numberOfDivisionsInHour) {
        this.numberOfAllDayEventRows = this.model.computeNumberOfAllDayEventRows();
        return (24 - this.model.computeStartHour()) * numberOfDivisionsInHour + this.numberOfAllDayEventRows;
    }

    private int convertViewportRowToDayRow(int row) {
        int topRowOffset = this.compositeTable.getTopRow() - this.numberOfAllDayEventRows;
        int startOfDayOffset = this.model.computeStartHour() * this.model.getNumberOfDivisionsInHour();
        return row + topRowOffset + startOfDayOffset;
    }

    private int convertDayRowToViewportCoordinates(int row) {
        return row -= this.model.computeStartHour() * this.model.getNumberOfDivisionsInHour() - this.numberOfAllDayEventRows;
    }

    private Date computeDateTimeFromViewportCoordinates(Point viewportSelection, int visibleAllDayEventRows) {
        Date startDate = this.model.calculateDate(this.getStartDate(), viewportSelection.x);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(startDate);
        calendar.set(11, this.model.computeHourFromRow(viewportSelection.y - visibleAllDayEventRows));
        calendar.set(12, this.model.computeMinuteFromRow(viewportSelection.y - visibleAllDayEventRows));
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private int computeRowForCalendarable(CalendarableItem calendarable, int day) {
        int row = 0;
        if (calendarable.isAllDayEvent()) {
            CalendarableItem[] allDayEvents = this.model.getAllDayCalendarables(day);
            int allDayEventRow = 0;
            while (allDayEventRow < allDayEvents.length) {
                if (allDayEvents[allDayEventRow] == calendarable) {
                    row = allDayEventRow - this.compositeTable.getTopRow();
                    break;
                }
                ++allDayEventRow;
            }
        } else {
            int startOfDayOffset;
            Point upperLeft = calendarable.getUpperLeftPositionInDayRowCoordinates();
            int topRowOffset = this.compositeTable.getTopRow() - this.numberOfAllDayEventRows;
            row = upperLeft.y - topRowOffset - (startOfDayOffset = this.model.computeStartHour() * this.model.getNumberOfDivisionsInHour());
            if (row < 0) {
                row = 0;
            }
        }
        return row;
    }

    private void updateVisibleRows() {
        this.compositeTable.setNumRowsInCollection(this.computeNumRowsInCollection(this.getNumberOfDivisionsInHour()));
    }

    private void refreshRow(int currentObjectOffset, TimeSlice timeSlice) {
        int allDayEventRow = 0;
        while (allDayEventRow < this.numberOfAllDayEventRows) {
            --currentObjectOffset;
            ++allDayEventRow;
        }
        if (currentObjectOffset < 0) {
            timeSlice.setCurrentTime(null);
        } else {
            this.calendar.set(11, this.model.computeHourFromRow(currentObjectOffset));
            this.calendar.set(12, this.model.computeMinuteFromRow(currentObjectOffset));
            timeSlice.setCurrentTime(this.calendar.getTime());
        }
    }

    protected void refreshColumnHeaders(LinkedList columns) {
        Date startDate = this.getStartDate();
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(startDate);
        SimpleDateFormat formatter = new SimpleDateFormat("EE, MMM d");
        formatter.applyLocalizedPattern(formatter.toLocalizedPattern());
        for (CLabel headerLabel : columns) {
            headerLabel.setText(formatter.format(gc.getTime()));
            gc.add(5, 1);
        }
    }

    private void freeObsoleteCalendarableEventControls(List removedCalendarables) {
        for (CalendarableItem toRemove : removedCalendarables) {
            if (this.selectedCalendarable == toRemove) {
                this.setSelection(null);
            }
            this.freeCalendarableControl(toRemove);
        }
    }

    private void computeEventRowsForDate(Date date) {
        GregorianCalendar targetDate = new GregorianCalendar();
        targetDate.setTime(date);
        GregorianCalendar target = new GregorianCalendar();
        target.setTime(this.model.getStartDate());
        EventLayoutComputer dayModel = new EventLayoutComputer(this.model.getNumberOfDivisionsInHour());
        int dayOffset = 0;
        while (dayOffset < this.model.getNumberOfDays()) {
            if (target.get(5) == targetDate.get(5) && target.get(2) == targetDate.get(2) && target.get(1) == targetDate.get(1)) {
                this.computeEventLayout(dayModel, dayOffset);
                break;
            }
            target.add(5, 1);
            ++dayOffset;
        }
    }

    private void computeEventRowsForNewDays() {
        EventLayoutComputer dayModel = new EventLayoutComputer(this.model.getNumberOfDivisionsInHour());
        int dayOffset = 0;
        while (dayOffset < this.model.getNumberOfDays()) {
            if (this.model.getNumberOfColumnsWithinDay(dayOffset) == -1) {
                this.computeEventLayout(dayModel, dayOffset);
            }
            ++dayOffset;
        }
    }

    private void computeEventLayout(EventLayoutComputer dayModel, int dayOffset) {
        List events = this.model.getCalendarableItems(dayOffset);
        CalendarableItem[][] eventLayout = dayModel.computeEventLayout(events);
        this.model.setEventLayout(dayOffset, eventLayout);
    }

    private void layoutEventControlsDeferred() {
        if (this.getStartDate() == null) {
            return;
        }
        this.refreshEventControlPositions.run();
        Display.getCurrent().asyncExec(this.refreshEventControlPositions);
    }

    private void layoutEventControls() {
        if (this.getStartDate() == null) {
            return;
        }
        this.refreshEventControlPositions.run();
    }

    protected Point[] computeColumns(int day, int numberOfColumns, Control[] gridRows) {
        Point[] columns = new Point[numberOfColumns];
        Rectangle timeSliceBounds = this.getTimeSliceBounds(day, this.compositeTable.getTopRow(), gridRows);
        timeSliceBounds.x += 4;
        timeSliceBounds.width -= 5;
        int baseWidth = timeSliceBounds.width / numberOfColumns;
        int extraWidth = timeSliceBounds.width % numberOfColumns;
        int startingPosition = timeSliceBounds.x;
        int column = 0;
        while (column < columns.length) {
            int columnStart = startingPosition;
            int columnWidth = baseWidth;
            if (extraWidth > 0) {
                ++columnWidth;
                --extraWidth;
            }
            columns[column] = new Point(columnStart, columnWidth);
            startingPosition += columnWidth;
            ++column;
        }
        return columns;
    }

    private void fillControlData(CalendarableItem calendarable, int clippingStyle) {
        calendarable.getControl().setText(calendarable.getText());
        calendarable.getControl().setToolTipText(calendarable.getToolTipText());
        calendarable.getControl().setClipping(clippingStyle);
    }

    private DayEditorCalendarableItemControl getControl(CalendarableItem item) {
        return (DayEditorCalendarableItemControl)item.getControl();
    }

    private void layoutAllDayEvent(int day, int allDayEventRow, CalendarableItem calendarable, Control[] gridRows) {
        if (this.eventRowIsVisible(allDayEventRow)) {
            this.createCalendarableControl(calendarable);
            this.fillControlData(calendarable, 0);
            Rectangle timeSliceBounds = this.getTimeSliceBounds(day, allDayEventRow, gridRows);
            int gutterWidth = 4;
            timeSliceBounds.x += gutterWidth;
            timeSliceBounds.width -= gutterWidth;
            this.getControl(calendarable).setBounds(timeSliceBounds);
            this.getControl(calendarable).moveAbove((Control)this.compositeTable);
        } else {
            this.freeCalendarableControl(calendarable);
        }
    }

    private void layoutTimedEvent(int day, Point[] columnPositions, CalendarableItem calendarable, Control[] gridRows) {
        int endRow;
        int startRow;
        int lastVisibleRow;
        int firstVisibleRow = this.model.computeStartHour() * this.model.getNumberOfDivisionsInHour();
        int scrolledRows = this.compositeTable.getTopRow() - this.numberOfAllDayEventRows;
        int visibleAllDayEventRows = 0;
        if (scrolledRows < 0) {
            visibleAllDayEventRows = -1 * scrolledRows;
            scrolledRows = 0;
        }
        if (this.timedEventIsVisible(firstVisibleRow += scrolledRows, lastVisibleRow = firstVisibleRow + this.compositeTable.getNumRowsVisible() - visibleAllDayEventRows - 1, startRow = calendarable.getUpperLeftPositionInDayRowCoordinates().y, endRow = calendarable.getLowerRightPositionInDayRowCoordinates().y)) {
            int clippingStyle = 0;
            if (startRow < firstVisibleRow) {
                startRow = firstVisibleRow;
                clippingStyle |= 0x80;
            }
            if (endRow > lastVisibleRow) {
                endRow = lastVisibleRow;
                clippingStyle |= 0x400;
            }
            startRow = this.convertDayRowToViewportCoordinates(startRow);
            endRow = this.convertDayRowToViewportCoordinates(endRow);
            this.createCalendarableControl(calendarable);
            this.fillControlData(calendarable, clippingStyle);
            Rectangle startRowBounds = this.getTimeSliceBounds(day, startRow, gridRows);
            Rectangle endRowBounds = this.getTimeSliceBounds(day, endRow, gridRows);
            int leftmostColumn = calendarable.getUpperLeftPositionInDayRowCoordinates().x;
            int rightmostColumn = calendarable.getLowerRightPositionInDayRowCoordinates().x;
            int left = columnPositions[leftmostColumn].x;
            int top = startRowBounds.y + 1;
            int width = columnPositions[rightmostColumn].x - columnPositions[leftmostColumn].x + columnPositions[rightmostColumn].y;
            int height = endRowBounds.y - startRowBounds.y + endRowBounds.height - 1;
            Rectangle finalPosition = new Rectangle(left, top, width, height);
            this.getControl(calendarable).setBounds(finalPosition);
            this.getControl(calendarable).moveAbove((Control)this.compositeTable);
        } else {
            this.freeCalendarableControl(calendarable);
        }
    }

    private boolean eventRowIsVisible(int eventRow) {
        int topRow = this.compositeTable.getTopRow();
        return topRow <= eventRow && eventRow < this.compositeTable.getNumRowsVisible() - topRow;
    }

    private boolean timedEventIsVisible(int firstVisibleRow, int lastVisibleRow, int startRow, int endRow) {
        if (startRow < firstVisibleRow && endRow < firstVisibleRow) {
            return false;
        }
        return startRow <= lastVisibleRow || endRow <= lastVisibleRow;
    }

    private void createCalendarableControl(CalendarableItem calendarable) {
        if (calendarable.getControl() == null) {
            calendarable.setControl(this.newCEC());
            if (calendarable == this.selectedCalendarable) {
                calendarable.getControl().setSelected(true);
            }
        }
    }

    private Rectangle getTimeSliceBounds(int day, int eventRow, Control[] gridRows) {
        int row = eventRow - this.compositeTable.getTopRow();
        TimeSlice rowObject = (TimeSlice)gridRows[row];
        Control slot = rowObject.getColumnControl(day);
        return this.getBoundsInDayEditorCoordinates(slot);
    }

    private void freeCalendarableControl(CalendarableItem calendarableItem) {
        if (calendarableItem.getControl() != null) {
            this.freeCEC(this.getControl(calendarableItem));
            calendarableItem.setControl(null);
            this.fireDisposeItemStrategy(calendarableItem);
        }
    }

    private Rectangle getBoundsInDayEditorCoordinates(Control slot) {
        return Display.getCurrent().map((Control)slot.getParent(), (Control)this, slot.getBounds());
    }

    private DayEditorCalendarableItemControl newCEC() {
        if (this.recycledCalendarableEventControls.size() > 0) {
            DayEditorCalendarableItemControl result = (DayEditorCalendarableItemControl)this.recycledCalendarableEventControls.remove(0);
            result.setVisible(true);
            return result;
        }
        DayEditorCalendarableItemControl dayEditorCalendarableItemControl = new DayEditorCalendarableItemControl(this, 0);
        if (this.menu != null) {
            dayEditorCalendarableItemControl.setMenu(this.menu);
        }
        dayEditorCalendarableItemControl.addMouseListener((MouseListener)this.selectCompositeTableOnMouseDownAdapter);
        return dayEditorCalendarableItemControl;
    }

    private void freeCEC(DayEditorCalendarableItemControl control) {
        control.setSelected(false);
        control.setCalendarableItem(null);
        control.setVisible(false);
        this.recycledCalendarableEventControls.add(control);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        super.setBackground(color);
        this.background = color;
        if (this.compositeTable != null) {
            this.compositeTable.setBackground(color);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if (!this.compositeTable.setFocus()) {
            return super.setFocus();
        }
        return true;
    }
}

