/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.riena.communication.core.attachment.IDataSource;

public class HttpURLDataSource
implements IDataSource {
    private HttpURLConnection httpUrlConnection;

    public HttpURLDataSource(URL url) throws IOException {
        HttpURLConnection myHttpUrlConnection = (HttpURLConnection)url.openConnection();
        assert (myHttpUrlConnection != null);
        this.httpUrlConnection = myHttpUrlConnection;
    }

    public String getContentType() {
        return this.httpUrlConnection.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        InputStream input = this.httpUrlConnection.getInputStream();
        if (input.markSupported()) {
            input.reset();
        }
        return input;
    }

    public String getName() {
        return this.httpUrlConnection.getURL().toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    public void checkValid() throws IOException {
        InputStream inputStream = this.httpUrlConnection.getInputStream();
        if (inputStream != null) {
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
        } else {
            throw new RuntimeException("no inputstream for http url " + this.httpUrlConnection.getURL());
        }
    }
}

