/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

final class LazyExecutableExtension
implements InvocationHandler {
    private final IConfigurationElement configurationElement;
    private final String name;
    private final boolean wire;
    private volatile Object delegate;

    static Object newInstance(IConfigurationElement configurationElement, String name, boolean wire) {
        String className = configurationElement.getAttribute(name);
        if (className == null) {
            return null;
        }
        Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)configurationElement.getContributor());
        if (bundle == null) {
            throw new IllegalStateException("Could not resolve bundle for configuration element " + configurationElement.getName());
        }
        try {
            Class clazz = bundle.loadClass(className);
            Class<?>[] interfaces = clazz.getInterfaces();
            if (interfaces.length == 0) {
                throw new IllegalStateException("Executable extension " + className + " within configuration element " + configurationElement.getName() + " does not have any interfaces, but they are required.");
            }
            return Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)new LazyExecutableExtension(configurationElement, name, wire));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not load class " + className + " from bundle " + bundle.getSymbolicName(), e);
        }
    }

    private LazyExecutableExtension(IConfigurationElement configurationElement, String name, boolean wire) {
        this.configurationElement = configurationElement;
        this.name = name;
        this.wire = wire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LazyExecutableExtension lazyExecutableExtension = this;
        synchronized (lazyExecutableExtension) {
            if (this.delegate == null) {
                this.delegate = this.configurationElement.createExecutableExtension(this.name);
                if (this.wire) {
                    Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)this.configurationElement.getContributor());
                    BundleContext context = bundle != null ? bundle.getBundleContext() : Activator.getDefault().getContext();
                    Wire.instance(this.delegate).andStart(context);
                }
            }
        }
        return method.invoke(this.delegate, args);
    }
}

