/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.injector.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.core.injector.service.ServiceDescriptor;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.osgi.framework.ServiceReference;

public class FilterInjector
extends ServiceInjector {
    private List<ServiceReference> trackedServiceRefs = null;

    FilterInjector(ServiceDescriptor serviceId, Object target) {
        super(serviceId, target);
    }

    protected void doStart() {
        this.trackedServiceRefs = new ArrayList<ServiceReference>(1);
        ServiceReference[] serviceRefs = this.getServiceReferences();
        this.registerServiceListener();
        if (serviceRefs != null) {
            ServiceReference[] serviceReferenceArray = serviceRefs;
            int n = serviceRefs.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference serviceRef = serviceReferenceArray[n2];
                this.doBind(serviceRef);
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() {
        ServiceReference[] serviceRefs;
        List<ServiceReference> list = this.trackedServiceRefs;
        synchronized (list) {
            serviceRefs = this.trackedServiceRefs.toArray(new ServiceReference[this.trackedServiceRefs.size()]);
        }
        ServiceReference[] serviceReferenceArray = serviceRefs;
        int n = serviceRefs.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceRef = serviceReferenceArray[n2];
            this.doUnbind(serviceRef);
            ++n2;
        }
        this.trackedServiceRefs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doBind(ServiceReference serviceRef) {
        List<ServiceReference> list = this.trackedServiceRefs;
        synchronized (list) {
            if (this.trackedServiceRefs.contains(serviceRef)) {
                return;
            }
            this.invokeBindMethod(serviceRef);
            this.trackedServiceRefs.add(serviceRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnbind(ServiceReference serviceRef) {
        List<ServiceReference> list = this.trackedServiceRefs;
        synchronized (list) {
            if (!this.trackedServiceRefs.contains(serviceRef)) {
                return;
            }
            this.invokeUnbindMethod(serviceRef);
            this.trackedServiceRefs.remove(serviceRef);
        }
    }
}

