/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.exceptionmanager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.exceptionmanager.IExceptionHandlerDefinition;
import org.eclipse.riena.internal.core.exceptionmanager.SimpleExceptionHandlerManagerWiring;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalNode;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalSort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WireWith(value=SimpleExceptionHandlerManagerWiring.class)
public class SimpleExceptionHandlerManager
implements IExceptionHandlerManager {
    private List<ExceptionHandlerEntry> handlers;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SimpleExceptionHandlerManager.class);

    public void update(IExceptionHandlerDefinition[] exceptionHandlerDefinitions) {
        this.handlers = new ArrayList<ExceptionHandlerEntry>();
        IExceptionHandlerDefinition[] iExceptionHandlerDefinitionArray = exceptionHandlerDefinitions;
        int n = exceptionHandlerDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionHandlerDefinition handlerDefinition = iExceptionHandlerDefinitionArray[n2];
            IExceptionHandler exceptionHandler = handlerDefinition.createExceptionHandler();
            if (exceptionHandler == null) {
                LOGGER.log(1, "could not instantiate exception handler " + handlerDefinition.getName() + " for class " + handlerDefinition.getExceptionHandler());
            }
            this.handlers = this.sort(this.handlers, exceptionHandler, handlerDefinition);
            ++n2;
        }
    }

    private List<ExceptionHandlerEntry> sort(List<ExceptionHandlerEntry> existingHandlers, IExceptionHandler handler, IExceptionHandlerDefinition definition) {
        ArrayList nodes = new ArrayList(existingHandlers.size() + 1);
        ExceptionHandlerEntry exceptionHandlerEntry = new ExceptionHandlerEntry(handler, definition.getName(), definition.getBefore());
        TopologicalNode<ExceptionHandlerEntry> node = new TopologicalNode<ExceptionHandlerEntry>(definition.getName(), definition.getBefore(), exceptionHandlerEntry);
        nodes.add(node);
        for (ExceptionHandlerEntry nextHandler : existingHandlers) {
            node = new TopologicalNode<ExceptionHandlerEntry>(nextHandler.getName(), nextHandler.getBefore(), nextHandler);
            nodes.add(node);
        }
        return TopologicalSort.sort(nodes);
    }

    @Override
    public IExceptionHandlerManager.Action handleException(Throwable t) {
        return this.handleException(t, null, LOGGER);
    }

    @Override
    public IExceptionHandlerManager.Action handleException(Throwable t, Logger logger) {
        return this.handleException(t, null, logger);
    }

    @Override
    public IExceptionHandlerManager.Action handleException(Throwable t, String msg) {
        return this.handleException(t, msg, LOGGER);
    }

    @Override
    public IExceptionHandlerManager.Action handleException(Throwable t, String msg, Logger logger) {
        for (ExceptionHandlerEntry handler : this.handlers) {
            IExceptionHandlerManager.Action action = handler.getExceptionHandler().handleException(t, msg, logger);
            if (action == IExceptionHandlerManager.Action.NOT_HANDLED) continue;
            return action;
        }
        return IExceptionHandlerManager.Action.NOT_HANDLED;
    }

    static class ExceptionHandlerEntry {
        private final IExceptionHandler exceptionHandler;
        private final String before;
        private final String name;

        public ExceptionHandlerEntry(IExceptionHandler exceptionHandler, String name, String before) {
            this.exceptionHandler = exceptionHandler;
            this.name = name;
            this.before = before;
        }

        public IExceptionHandler getExceptionHandler() {
            return this.exceptionHandler;
        }

        public String getBefore() {
            return this.before;
        }

        public String getName() {
            return this.name;
        }
    }
}

