/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.wire;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.injector.extension.ExtensionDescriptor;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.wire.InjectExtension;

public class ExtensionInjectorBuilder {
    private final Object bean;
    private final Method method;
    private final InjectExtension annotation;

    public ExtensionInjectorBuilder(Object bean, Method method) {
        Assert.isLegal((bean != null ? 1 : 0) != 0, (String)"bean must not be null");
        Assert.isLegal((method != null ? 1 : 0) != 0, (String)"method must not be null");
        this.bean = bean;
        this.method = method;
        this.annotation = method.getAnnotation(InjectExtension.class);
        Assert.isLegal((this.annotation != null ? 1 : 0) != 0, (String)"annotation must not be null");
    }

    public ExtensionInjector build() {
        ExtensionDescriptor descriptor = Inject.extension(this.annotation.id());
        Class<?>[] types = this.method.getParameterTypes();
        Assert.isLegal((types.length == 1 ? 1 : 0) != 0, (String)"only one parameter allowed on \u00b4update\u00b4 method");
        descriptor = types[0].isArray() ? descriptor.expectingMinMax(this.annotation.min(), this.annotation.max()).useType(types[0].getComponentType()) : descriptor.expectingExactly(1).useType(types[0]);
        if (this.annotation.heterogeneous()) {
            descriptor = descriptor.heterogeneous();
        }
        ExtensionInjector injector = descriptor.into(this.bean);
        if (this.annotation.doNotReplaceSymbols()) {
            injector = injector.doNotReplaceSymbols();
        }
        if (this.annotation.specific()) {
            injector = injector.specific();
        }
        return injector.update(this.method.getName());
    }
}

