/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.UIProcessFinishedMarker;
import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.FlasherSupportForRenderer;
import org.eclipse.riena.ui.swt.lnf.ILnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubModuleTreeItemMarkerRenderer
extends AbstractLnfRenderer {
    private TreeItem item;
    private FlasherSupportForRenderer flasherSupport = new FlasherSupportForRenderer((ILnfRenderer)this, (Runnable)new MarkerUpdater());

    public void paint(GC gc, Object value) {
        Assert.isNotNull((Object)gc);
        Assert.isNotNull((Object)value);
        Assert.isTrue((boolean)(value instanceof TreeItem));
        this.item = (TreeItem)value;
        this.flasherSupport.startFlasher();
        Collection markers = this.getMarkersOfType(IIconizableMarker.class);
        if (!markers.isEmpty()) {
            this.paintMarkers(gc, markers, this.item);
        }
    }

    protected void paintMarkers(GC gc, Collection<IIconizableMarker> markers, TreeItem item) {
        for (IIconizableMarker iconizableMarker : markers) {
            MandatoryMarker mandatoryMarker;
            if (iconizableMarker instanceof MandatoryMarker && (mandatoryMarker = (MandatoryMarker)iconizableMarker).isDisabled()) continue;
            if (iconizableMarker instanceof UIProcessFinishedMarker && !this.flasherSupport.isProcessMarkerVisible()) {
                return;
            }
            Image itemImage = item.getImage();
            String key = iconizableMarker.getIconConfigurationKey();
            Image markerImage = LnfManager.getLnf().getImage(key);
            Point pos = this.calcMarkerCoordinates(itemImage, markerImage, iconizableMarker.getPositionOfMarker());
            gc.drawImage(markerImage, pos.x, pos.y);
        }
    }

    private Point calcMarkerCoordinates(Image itemImage, Image markerImage, IIconizableMarker.MarkerPosition position) {
        Rectangle itemImageBounds = new Rectangle(0, 0, 0, 0);
        if (itemImage != null) {
            ImageData imageData = itemImage.getImageData();
            itemImageBounds = new Rectangle(imageData.x, imageData.y, imageData.width, imageData.height);
        }
        Rectangle itemMarkerBounds = new Rectangle(0, 0, 0, 0);
        if (markerImage != null) {
            ImageData imageData = markerImage.getImageData();
            itemMarkerBounds = new Rectangle(imageData.x, imageData.y, imageData.width, imageData.height);
        }
        int x = this.getBounds().x;
        x += itemImageBounds.x;
        int y = this.getBounds().y;
        y += itemImageBounds.y;
        switch (position) {
            case TOP_RIGHT: {
                x += itemImageBounds.width - itemMarkerBounds.width;
                break;
            }
            case BOTTOM_LEFT: {
                y += itemImageBounds.height - itemMarkerBounds.height;
                break;
            }
            case BOTTOM_RIGHT: {
                x += itemImageBounds.width - itemMarkerBounds.width;
                y += itemImageBounds.height - itemMarkerBounds.height;
                break;
            }
        }
        return new Point(x, y);
    }

    public void dispose() {
        this.item = null;
        this.flasherSupport = null;
    }

    private class MarkerUpdater
    implements Runnable {
        private MarkerUpdater() {
        }

        public void run() {
            SubModuleTreeItemMarkerRenderer.this.item.getParent().redraw();
        }
    }
}

