/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.services;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.riena.core.RienaActivator;
import org.eclipse.riena.core.RienaConstants;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.authenticationservice.AuthenticationService;
import org.eclipse.riena.internal.security.authorizationservice.AuthorizationService;
import org.eclipse.riena.internal.security.sessionservice.SessionService;
import org.eclipse.riena.security.authorizationservice.IPermissionStore;
import org.eclipse.riena.security.common.ISubjectHolderService;
import org.eclipse.riena.security.common.authentication.IAuthenticationService;
import org.eclipse.riena.security.common.authorization.IAuthorizationService;
import org.eclipse.riena.security.common.session.ISessionHolderService;
import org.eclipse.riena.security.server.session.ISessionService;
import org.eclipse.riena.security.sessionservice.ISessionProvider;
import org.eclipse.riena.security.sessionservice.ISessionStore;
import org.eclipse.riena.security.sessionservice.SessionProvider;
import org.osgi.framework.BundleContext;

public class Activator
extends RienaActivator {
    public static final String PLUGIN_ID = "org.eclipse.riena.security.services";
    private static Activator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.createAuthenticationServiceAndInjectors();
        this.createAuthorizationServiceAndInjectors();
        this.createSessionServiceAndInjectors();
        this.createSessionProviderAndInjectors();
    }

    private void createAuthenticationServiceAndInjectors() {
        AuthenticationService authenticationService = new AuthenticationService();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/AuthenticationService");
        this.getContext().registerService(IAuthenticationService.class.getName(), (Object)authenticationService, (Dictionary)properties);
        Inject.service((String)ISessionService.class.getName()).useRanking().into((Object)authenticationService).andStart(Activator.getDefault().getContext());
        Inject.service((String)ISubjectHolderService.class.getName()).useRanking().into((Object)authenticationService).andStart(Activator.getDefault().getContext());
        Inject.service((String)ISessionHolderService.class.getName()).useRanking().into((Object)authenticationService).andStart(Activator.getDefault().getContext());
    }

    private void createAuthorizationServiceAndInjectors() {
        AuthorizationService authorizationService = new AuthorizationService();
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/AuthorizationService");
        this.getContext().registerService(IAuthorizationService.class.getName(), (Object)authorizationService, (Dictionary)properties);
        Inject.service((String)IPermissionStore.class.getName()).useRanking().into((Object)authorizationService).andStart(Activator.getDefault().getContext());
    }

    private void createSessionServiceAndInjectors() {
        Hashtable properties = RienaConstants.newDefaultServiceProperties();
        properties.put("riena.remote", Boolean.TRUE.toString());
        properties.put("riena.remote.protocol", "hessian");
        properties.put("riena.remote.path", "/SessionService");
        SessionService sessionService = new SessionService();
        this.getContext().registerService(ISessionService.class.getName(), (Object)sessionService, (Dictionary)properties);
        Inject.service((String)ISessionStore.class.getName()).into((Object)sessionService).andStart(Activator.getDefault().getContext());
        Inject.service((String)ISessionProvider.class.getName()).into((Object)sessionService).andStart(Activator.getDefault().getContext());
    }

    private void createSessionProviderAndInjectors() {
        this.getContext().registerService(ISessionProvider.class.getName(), (Object)new SessionProvider(), (Dictionary)RienaConstants.newDefaultServiceProperties());
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

