/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.simpleservices.authentication.loginmodule;

import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.security.simpleservices.Activator;
import org.eclipse.riena.security.common.authentication.SimplePrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private String password;
    private Properties accounts;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SampleLoginModule.class);

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        this.subject.getPrincipals().add((Principal)new SimplePrincipal(this.username));
        return true;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        try {
            this.accounts = this.loadProperties((String)options.get("accounts.file"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Properties loadProperties(String path) throws IOException {
        URL url = Activator.getDefault().getContext().getBundle().getEntry(path);
        Properties properties = new Properties();
        properties.load(url.openStream());
        return properties;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("username: "), new PasswordCallback("password: ", false)};
        if (this.callbackHandler == null) {
            LOGGER.log(1, "callbackhandler cant be null");
            return false;
        }
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            this.password = new String(((PasswordCallback)callbacks[1]).getPassword());
            String psw = (String)this.accounts.get(this.username);
            return psw != null && psw.equals(this.password);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (UnsupportedCallbackException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean logout() throws LoginException {
        return false;
    }
}

