/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.factory;

import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.factory.IRSFTest;
import org.eclipse.riena.communication.core.factory.RemoteServiceFactory;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.communication.console.Activator;
import org.eclipse.riena.internal.communication.core.registry.RemoteServiceRegistry;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

@NonUITestCase
public class RemoteServiceFactoryTest
extends RienaTestCase {
    private RemoteServiceRegistry remoteServiceRegistry = null;

    protected void setUp() throws Exception {
        super.setUp();
        Inject.service(IRemoteServiceRegistry.class).into((Object)this).andStart(org.eclipse.riena.internal.tests.Activator.getDefault().getContext());
    }

    public void bind(IRemoteServiceRegistry rsf) {
        this.remoteServiceRegistry = (RemoteServiceRegistry)rsf;
    }

    public void unbind(IRemoteServiceRegistry rsf) {
        this.remoteServiceRegistry = null;
    }

    protected void tearDown() throws Exception {
        ServiceReference serviceReference;
        super.tearDown();
        BundleContext context = org.eclipse.riena.internal.tests.Activator.getDefault().getContext();
        while ((serviceReference = context.getServiceReference(IRSFTest.class.getName())) != null) {
            ServiceRegistration registration = (ServiceRegistration)ReflectionUtils.getHidden((Object)serviceReference, (String)"registration");
            registration.unregister();
        }
    }

    public void testUnregister() throws Exception {
        BundleContext context = org.eclipse.riena.internal.tests.Activator.getDefault().getContext();
        IRemoteServiceRegistration createAndRegisterProxy = new RemoteServiceFactory().createAndRegisterProxy(IRSFTest.class, "http://localhost", "hessian", context);
        Object service = context.getService(context.getServiceReference(IRSFTest.class.getName()));
        RemoteServiceFactoryTest.assertNotNull((Object)service);
        createAndRegisterProxy.unregister();
        ServiceReference serviceReference = context.getServiceReference(IRSFTest.class.getName());
        RemoteServiceFactoryTest.assertNull((String)"assuming that serviceReference is null when unregister is called", (Object)serviceReference);
        RemoteServiceFactoryTest.assertFalse((String)"asssuming that service is no longer in registry if service proxy is gone", (boolean)this.remoteServiceRegistry.hasServiceForUrl("http://localhost"));
    }

    public void testUnregisterForOtherBundle() throws Exception {
        BundleContext context = Activator.getDefault().getContext();
        IRemoteServiceRegistration createAndRegisterProxy = new RemoteServiceFactory().createAndRegisterProxy(IRSFTest.class, "http://localhost", "hessian", context);
        Object service = context.getService(context.getServiceReference(IRSFTest.class.getName()));
        RemoteServiceFactoryTest.assertNotNull((Object)service);
        createAndRegisterProxy.unregister();
        ServiceReference serviceReference = context.getServiceReference(IRSFTest.class.getName());
        RemoteServiceFactoryTest.assertNull((String)"assuming that serviceReference is null when unregister is called", (Object)serviceReference);
        RemoteServiceFactoryTest.assertFalse((String)"asssuming that service is no longer in registry if service proxy is gone", (boolean)this.remoteServiceRegistry.hasServiceForUrl("http://localhost"));
    }

    public void testUnregisterForOtherBundleAndStopOtherBundle() throws Exception {
        super.startBundle("org.eclipse.riena.communication.console");
        BundleContext context = Activator.getDefault().getContext();
        new RemoteServiceFactory().createAndRegisterProxy(IRSFTest.class, "http://localhost", "hessian", context);
        Object service = context.getService(context.getServiceReference(IRSFTest.class.getName()));
        RemoteServiceFactoryTest.assertNotNull((Object)service);
        context.getBundle().stop();
        ServiceReference serviceReference = org.eclipse.riena.internal.tests.Activator.getDefault().getContext().getServiceReference(IRSFTest.class.getName());
        RemoteServiceFactoryTest.assertNull((String)"assuming that serviceReference is null when bundle is stopped", (Object)serviceReference);
        RemoteServiceFactoryTest.assertFalse((String)"asssuming that service is no longer in registry if service proxy is gone", (boolean)this.remoteServiceRegistry.hasServiceForUrl("http://localhost"));
    }

    public void testUnregisterForOtherBundleAndStopOtherBundleAndUnregister() throws Exception {
        super.startBundle("org.eclipse.riena.communication.console");
        BundleContext context = Activator.getDefault().getContext();
        IRemoteServiceRegistration createAndRegisterProxy = new RemoteServiceFactory().createAndRegisterProxy(IRSFTest.class, "http://localhost", "hessian", context);
        Object service = context.getService(context.getServiceReference(IRSFTest.class.getName()));
        RemoteServiceFactoryTest.assertNotNull((Object)service);
        context.getBundle().stop();
        try {
            createAndRegisterProxy.unregister();
            RemoteServiceFactoryTest.fail((String)"unregister of proxy for dead context should not be possible");
        }
        catch (IllegalStateException illegalStateException) {
            this.ok("expected exception");
        }
        ServiceReference serviceReference = org.eclipse.riena.internal.tests.Activator.getDefault().getContext().getServiceReference(IRSFTest.class.getName());
        RemoteServiceFactoryTest.assertNull((String)"assuming that serviceReference is null when bundle is stopped and unregister is called", (Object)serviceReference);
        RemoteServiceFactoryTest.assertFalse((String)"asssuming that service is no longer in registry if service proxy is gone", (boolean)this.remoteServiceRegistry.hasServiceForUrl("http://localhost"));
    }
}

