/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.cache;

import org.eclipse.riena.core.cache.IGenericObjectCache;
import org.eclipse.riena.core.cache.LRUCache;
import org.eclipse.riena.internal.core.ignore.Nop;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.ManualTestCase;

@ManualTestCase
public class LRUCacheTest
extends RienaTestCase {
    private IGenericObjectCache<String, Integer> genericCache;
    private IGenericObjectCache<Integer, TestRunner> genericCache2;
    private IGenericObjectCache<Integer, String> genericCache3;

    public void setUp() throws Exception {
        super.setUp();
        this.genericCache = new LRUCache();
    }

    public void tearDown() throws Exception {
        this.genericCache = null;
        super.tearDown();
    }

    public void testInstantiate() {
        this.genericCache.put((Object)"test", (Object)2);
        LRUCacheTest.assertNotNull((String)"did not find put object in cache", (Object)this.genericCache.get((Object)"test"));
        LRUCacheTest.assertTrue((String)"object in cache has incorrect value", (boolean)((Integer)this.genericCache.get((Object)"test")).equals(2));
        this.genericCache.clear();
    }

    public void testTimeout() throws Exception {
        this.genericCache.put((Object)"test", (Object)3);
        this.genericCache.setTimeout(500);
        Thread.sleep(100L);
        LRUCacheTest.assertNotNull((String)"did not find put object in cache", (Object)this.genericCache.get((Object)"test"));
        Thread.sleep(600L);
        LRUCacheTest.assertNull((String)"must not find object in cache after timeout", (Object)this.genericCache.get((Object)"test"));
        this.genericCache.clear();
    }

    public void testPutMultiple() throws Exception {
        this.genericCache3 = new LRUCache();
        int i = 0;
        while (i < 30) {
            this.genericCache3.put((Object)i, (Object)"testvalue");
            ++i;
        }
        i = 0;
        while (i < 30) {
            LRUCacheTest.assertNotNull((String)"object not found in cache", (Object)this.genericCache3.get((Object)i));
            ++i;
        }
        this.genericCache.clear();
    }

    public void testMultiThread() throws Exception {
        this.genericCache2 = new LRUCache();
        Thread[] runner = new Thread[10];
        int i = 0;
        while (i < 10) {
            runner[i] = new TestRunner(i * 20, i * 20 + 19, 10);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache2.clear();
    }

    public void testMultiThreadSameRange() throws Exception {
        this.genericCache2 = new LRUCache();
        Thread[] runner = new Thread[10];
        int i = 0;
        while (i < 10) {
            runner[i] = new TestRunner(0, 20, 10);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache2.clear();
    }

    public void testMultiThreadLargeNoOfThreadsSameRange() throws Exception {
        this.genericCache2 = new LRUCache();
        Thread[] runner = new Thread[100];
        int i = 0;
        while (i < 100) {
            runner[i] = new TestRunner(0, 20, 100);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache2.clear();
    }

    public void testMultiThreadLargeNoOfThreads() throws Exception {
        this.genericCache2 = new LRUCache();
        Thread[] runner = new Thread[100];
        int i = 0;
        while (i < 100) {
            runner[i] = new TestRunner(i * 20, i * 20 + 19, 100);
            ++i;
        }
        this.runAndCheckThreads(runner);
        this.genericCache2.clear();
    }

    private void runAndCheckThreads(Thread[] runner) {
        int i = 0;
        while (i < runner.length) {
            runner[i].start();
            ++i;
        }
        int count = 0;
        boolean first = true;
        Thread.yield();
        while (count != 0 || first) {
            count = 0;
            int i2 = 0;
            while (i2 < runner.length) {
                if (runner[i2].isAlive()) {
                    ++count;
                }
                ++i2;
            }
            first = false;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Nop.reason((String)"no action");
            }
        }
    }

    class TestRunner
    extends Thread {
        private int lowRange;
        private int highRange;
        private int runs;

        TestRunner(int lowRange, int highRange, int runs) {
            this.lowRange = lowRange;
            this.highRange = highRange;
            this.runs = runs;
        }

        public void run() {
            int i = 0;
            while (i < this.runs) {
                int k = this.lowRange;
                while (k <= this.highRange) {
                    LRUCacheTest.this.genericCache2.put((Object)k, (Object)this);
                    ++k;
                }
                k = this.lowRange;
                while (k <= this.highRange) {
                    LRUCacheTest.assertNotNull((String)"object not found in cache", (Object)LRUCacheTest.this.genericCache2.get((Object)k));
                    ++k;
                }
                ++i;
            }
        }
    }
}

