/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import org.eclipse.riena.core.injector.service.FilterInjector;
import org.eclipse.riena.core.injector.service.RankingInjector;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.core.wire.Schtonk;
import org.eclipse.riena.internal.core.wire.ServiceInjectorBuilder;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;

@NonUITestCase
public class ServiceInjectorBuilderTest
extends RienaTestCase {
    public void testBuildForBind1() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getDeclaredMethod("bind1", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build();
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getService(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind1", (String)this.getBind(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"unbind1", (String)this.getUnbind(injector));
    }

    @InjectService(service=Schtonk.class)
    public void bind1(Schtonk schtonk) {
    }

    public void testBuildForBind2() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getDeclaredMethod("bind2", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build();
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof RankingInjector));
        ServiceInjectorBuilderTest.assertTrue((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getService(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind2", (String)this.getBind(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"entbinde", (String)this.getUnbind(injector));
    }

    @InjectService(serviceName="org.eclipse.riena.core.wire.Schtonk", useRanking=true, unbind="entbinde")
    public void bind2(Schtonk schtonk) {
    }

    public void testBuildForBind3() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getDeclaredMethod("bind3", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build();
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"(mellita = gut)", (String)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getService(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind3", (String)this.getBind(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"entbinde", (String)this.getUnbind(injector));
    }

    @InjectService(serviceName="org.eclipse.riena.core.wire.Schtonk", useFilter="(mellita = gut)", unbind="entbinde")
    public void bind3(Schtonk schtonk) {
    }

    public void testBuildForBind4() throws NoSuchMethodException {
        Method bindMethod = ServiceInjectorBuilderTest.class.getDeclaredMethod("bind4", Schtonk.class);
        ServiceInjectorBuilder builder = new ServiceInjectorBuilder((Object)this, bindMethod);
        ServiceInjector injector = builder.build();
        ServiceInjectorBuilderTest.assertNotNull((Object)injector);
        ServiceInjectorBuilderTest.assertTrue((boolean)(injector instanceof FilterInjector));
        ServiceInjectorBuilderTest.assertFalse((boolean)this.useRanking(injector));
        ServiceInjectorBuilderTest.assertNull((Object)this.getFilter(injector));
        ServiceInjectorBuilderTest.assertEquals((Object)Schtonk.class.getName(), (Object)this.getService(injector));
        ServiceInjectorBuilderTest.assertSame((Object)((Object)this), (Object)this.getBean(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"bind4", (String)this.getBind(injector));
        ServiceInjectorBuilderTest.assertEquals((String)"unbind4", (String)this.getUnbind(injector));
    }

    @InjectService
    public void bind4(Schtonk schtonk) {
    }

    private boolean useRanking(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return (Boolean)ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"ranking");
    }

    private String getFilter(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return (String)ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"filter");
    }

    private Object getService(ServiceInjector injector) {
        Object serviceDescriptor = ReflectionUtils.getHidden((Object)injector, (String)"serviceDesc");
        return ReflectionUtils.getHidden((Object)serviceDescriptor, (String)"clazz");
    }

    private Object getBean(ServiceInjector injector) {
        return ReflectionUtils.getHidden((Object)injector, (String)"target");
    }

    private String getBind(ServiceInjector injector) {
        return (String)ReflectionUtils.getHidden((Object)injector, (String)"bindMethodName");
    }

    private String getUnbind(ServiceInjector injector) {
        return (String)ReflectionUtils.getHidden((Object)injector, (String)"unbindMethodName");
    }
}

