/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.controllers;

import junit.framework.TestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.EmbeddedTitleBarRidget;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.IWindowRidget;

@NonUITestCase
public class SubModuleControllerTest
extends TestCase {
    public void testGetFullTitle() {
        ModuleNode module = new ModuleNode("m");
        new ModuleController((IModuleNode)module);
        SubModuleNode subModule1 = new SubModuleNode("sm1");
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        MySubModuleController smController1 = new MySubModuleController((ISubModuleNode)subModule1);
        SubModuleControllerTest.assertEquals((String)"m", (String)smController1.getFullTitle());
        module.setPresentSingleSubModule(true);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleNode subModule2 = new SubModuleNode("sm2");
        MySubModuleController smController2 = new MySubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        module.setPresentSingleSubModule(false);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        SubModuleNode subModule3 = new SubModuleNode("sm3");
        MySubModuleController smController3 = new MySubModuleController((ISubModuleNode)subModule3);
        subModule3.setParent((INavigationNode)subModule1);
        subModule1.addChild((INavigationNode)subModule3);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm2", (String)smController2.getFullTitle());
        SubModuleControllerTest.assertEquals((String)"m - sm1 - sm3", (String)smController3.getFullTitle());
    }

    public void testUpdateIcon() {
        EmbeddedTitleBarRidget windowRidget = new EmbeddedTitleBarRidget();
        ModuleNode module = new ModuleNode("m");
        module.setIcon("mIcon");
        new ModuleController((IModuleNode)module);
        SubModuleNode subModule1 = new SubModuleNode("sm1");
        subModule1.setIcon("sm1Icon");
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        MySubModuleController smController1 = new MySubModuleController((ISubModuleNode)subModule1);
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"mIcon", (String)windowRidget.getIcon());
        module.setPresentSingleSubModule(true);
        SubModuleControllerTest.assertEquals((String)"m - sm1", (String)smController1.getFullTitle());
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm1Icon", (String)windowRidget.getIcon());
        SubModuleNode subModule2 = new SubModuleNode("sm2");
        subModule2.setIcon("sm2Icon");
        MySubModuleController smController2 = new MySubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        smController1.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm1Icon", (String)windowRidget.getIcon());
        smController2.updateIcon((IWindowRidget)windowRidget);
        SubModuleControllerTest.assertEquals((String)"sm2Icon", (String)windowRidget.getIcon());
    }

    public void testIsInvisibleInTree() {
        SubModuleNode subModule1 = new SubModuleNode("sm1");
        SubModuleController smController1 = new SubModuleController((ISubModuleNode)subModule1);
        boolean ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        ModuleNode module = new ModuleNode("m");
        new ModuleController((IModuleNode)module);
        subModule1.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule1);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertTrue((boolean)ret);
        module.setPresentSingleSubModule(true);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        module.setPresentSingleSubModule(false);
        SubModuleNode subModule2 = new SubModuleNode("sm2");
        subModule2.setIcon("sm2Icon");
        SubModuleController smController2 = new SubModuleController((ISubModuleNode)subModule2);
        subModule2.setParent((INavigationNode)module);
        module.addChild((INavigationNode)subModule2);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController1, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
        ret = (Boolean)ReflectionUtils.invokeHidden((Object)smController2, (String)"isInvisibleInTree", (Object[])new Object[0]);
        SubModuleControllerTest.assertFalse((boolean)ret);
    }

    private static class MySubModuleController
    extends SubModuleController {
        public MySubModuleController(ISubModuleNode navigationNode) {
            super(navigationNode);
        }

        public String getFullTitle() {
            return super.getFullTitle();
        }

        public void updateIcon(IWindowRidget windowRidget) {
            super.updateIcon(windowRidget);
        }
    }
}

