/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation.tests;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.tests.RienaTestCase;
import org.eclipse.riena.tests.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.validation.ValidDecimal;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;

@NonUITestCase
public class ValidDecimalTest
extends RienaTestCase {
    public final void testUSlocale() throws Exception {
        ValidDecimal rule = new ValidDecimal(Locale.US);
        ValidDecimalTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)".123").isOK());
        ValidDecimalTest.assertEquals((Object)0.123, (Object)DecimalFormat.getInstance(Locale.US).parse(".123").doubleValue());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)".").isOK());
        try {
            ValidDecimalTest.assertEquals((Object)0.0, (Object)DecimalFormat.getInstance(Locale.US).parse(".").doubleValue());
            ValidDecimalTest.fail((String)"expected a ParseException");
        }
        catch (ParseException parseException) {
            this.ok("passed test");
        }
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0.").isOK());
        ValidDecimalTest.assertEquals((Object)0.0, (Object)DecimalFormat.getInstance(Locale.US).parse("0.").doubleValue());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"145").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"156").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0,00").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,01").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,000").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123,31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidDecimalTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public final void testGermanLocale() throws Exception {
        ValidDecimal rule = new ValidDecimal(Locale.GERMANY);
        ValidDecimalTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)",123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)",").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"145").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"156").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0.00").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.01").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.000").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123.31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,23A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidDecimalTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public final void testSwissLocale() throws Exception {
        ValidDecimal rule = new ValidDecimal(new Locale("de", "CH"));
        ValidDecimalTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1'234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1'234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 123.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1'234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)".123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)".").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)",").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"145").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"156").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0,00").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,01").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,000").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123,31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.234,31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,23A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidDecimalTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public final void testFrenchLocale() throws Exception {
        ValidDecimal rule = new ValidDecimal(Locale.FRANCE);
        ValidDecimalTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1 234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1 234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 0,00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,01").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 123,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1 234,31").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)",123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)",").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"145").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"156").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"0.00").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.01").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.000").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123.31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidDecimalTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public void testPartialCheckUSlocale() throws Exception {
        ValidDecimal rule = new ValidDecimal(true, Locale.US);
        ValidDecimalTest.assertTrue((boolean)rule.validate(null).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.23").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1.").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)".1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"10").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.23").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1.").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-.1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-10").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"-1,000").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 0.00").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.23").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1.").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- .1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 10").isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)"- 1,000").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)".").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"A123").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"1.23A").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"123A321").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"abcdefghijklmnopqrstuvwxyz").isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)"ABCDEFGHIJKLMBNOPQRSTUVWXYZ").isOK());
        try {
            rule.validate(new Object());
            ValidDecimalTest.fail((String)"expected a thrown ValidationFailure");
        }
        catch (ValidationFailure validationFailure) {
            this.ok("expected a thrown ValidationFailure");
        }
    }

    public final void testHindiLocale() throws Exception {
        Locale hindi = new Locale("hi", "IN");
        ValidDecimal rule = new ValidDecimal(hindi);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(hindi);
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)format.format(10L)).isOK());
        ValidDecimal partial = new ValidDecimal(true, hindi);
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(10L)).isOK());
    }

    public final void testThailandLocale() throws Exception {
        Locale thailand = new Locale("th", "TH");
        ValidDecimal rule = new ValidDecimal(thailand);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(thailand);
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)format.format(10L)).isOK());
        ValidDecimal partial = new ValidDecimal(true, thailand);
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(10L)).isOK());
    }

    public final void testArabLocale() throws Exception {
        Locale arabEmirates = new Locale("ar", "AE");
        ValidDecimal rule = new ValidDecimal(arabEmirates);
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance(arabEmirates);
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertFalse((boolean)rule.validate((Object)format.format(10L)).isOK());
        ValidDecimal partial = new ValidDecimal(true, arabEmirates);
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(-12.3)).isOK());
        ValidDecimalTest.assertTrue((boolean)rule.validate((Object)format.format(-12345.67)).isOK());
        ValidDecimalTest.assertTrue((boolean)partial.validate((Object)format.format(10L)).isOK());
    }

    public final void testSetLocalStringArray() throws Exception {
        MyValidDecimal validator = new MyValidDecimal();
        Locale locale = (Locale)ReflectionUtils.getHidden((Object)((Object)validator), (String)"locale");
        ValidDecimalTest.assertSame((Object)locale, (Object)Locale.getDefault());
        validator.setLocal(new String[0]);
        locale = (Locale)ReflectionUtils.getHidden((Object)((Object)validator), (String)"locale");
        ValidDecimalTest.assertSame((Object)locale, (Object)Locale.getDefault());
        validator.setLocal(new String[]{"hi"});
        locale = (Locale)ReflectionUtils.getHidden((Object)((Object)validator), (String)"locale");
        ValidDecimalTest.assertEquals((String)"hi", (String)locale.getLanguage());
        ValidDecimalTest.assertEquals((String)"", (String)locale.getCountry());
        ValidDecimalTest.assertEquals((String)"", (String)locale.getVariant());
        validator.setLocal(new String[]{"hi", "IND"});
        locale = (Locale)ReflectionUtils.getHidden((Object)((Object)validator), (String)"locale");
        ValidDecimalTest.assertEquals((String)"hi", (String)locale.getLanguage());
        ValidDecimalTest.assertEquals((String)"IND", (String)locale.getCountry());
        ValidDecimalTest.assertEquals((String)"", (String)locale.getVariant());
        validator.setLocal(new String[]{"es", "ES", "Traditional_WIN"});
        locale = (Locale)ReflectionUtils.getHidden((Object)((Object)validator), (String)"locale");
        ValidDecimalTest.assertEquals((String)"es", (String)locale.getLanguage());
        ValidDecimalTest.assertEquals((String)"ES", (String)locale.getCountry());
        ValidDecimalTest.assertEquals((String)"Traditional_WIN", (String)locale.getVariant());
    }

    public void testSetInitializationData() throws Exception {
        ValidDecimal validator = new ValidDecimal();
        String localString = String.valueOf(Locale.US.getLanguage()) + "," + Locale.US.getCountry();
        validator.setInitializationData(null, null, (Object)("false," + localString));
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertFalse((boolean)validator.validate((Object)"1").isOK());
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1.").isOK());
        validator = new ValidDecimal();
        validator.setInitializationData(null, null, (Object)("true," + localString));
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1,234.31").isOK());
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1").isOK());
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1.").isOK());
        validator = new ValidDecimal();
        localString = String.valueOf(Locale.GERMANY.getLanguage()) + "," + Locale.GERMANY.getCountry();
        validator.setInitializationData(null, null, (Object)("false," + localString));
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1.234,31").isOK());
        ValidDecimalTest.assertFalse((boolean)validator.validate((Object)"1").isOK());
        ValidDecimalTest.assertTrue((boolean)validator.validate((Object)"1,").isOK());
    }

    private static class MyValidDecimal
    extends ValidDecimal {
        private MyValidDecimal() {
        }

        public void setLocal(String[] localArgs) {
            super.setLocal(localArgs);
        }
    }
}

