/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.DateAndTimeObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

public class DateTimeRidget
extends AbstractEditableRidget
implements IDateTimeRidget,
ITextRidget {
    private IObservableValue ridgetObservable;
    private DataBindingContext dbc;
    private Binding controlBinding;

    public DateTimeRidget() {
        this.addPropertyChangeListener("output", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DateTimeRidget.this.updateEditable();
            }
        });
        this.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                DateTimeRidget.this.updateEditable();
            }
        });
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTWidgetRidget.assertType(uiControl, DateTime.class);
    }

    protected void bindUIControl() {
        DateTime control = this.getUIControl();
        if (control != null) {
            ISWTObservableValue dateObservable;
            ISWTObservableValue timeObservable;
            this.updateEditable();
            this.dbc = new DataBindingContext();
            Date nonNullDate = this.getNonNullDate(this.getDate());
            if (this.isTimeControl(control)) {
                timeObservable = WidgetProperties.selection().observe((Widget)control);
                timeObservable.setValue((Object)nonNullDate);
                dateObservable = new WritableValue(timeObservable.getRealm(), (Object)nonNullDate, Date.class);
            } else {
                dateObservable = WidgetProperties.selection().observe((Widget)control);
                dateObservable.setValue((Object)nonNullDate);
                timeObservable = new WritableValue(dateObservable.getRealm(), (Object)nonNullDate, Date.class);
            }
            this.controlBinding = this.dbc.bindValue((IObservableValue)new DateAndTimeObservableWithNullConversion((IObservableValue)dateObservable, (IObservableValue)timeObservable), this.getRidgetObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterGetValidator((IValidator)new EditRulesValidator()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        }
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.dbc != null) {
            this.dbc.dispose();
            this.dbc = null;
        }
    }

    protected final IObservableValue getRidgetObservable() {
        if (this.ridgetObservable == null) {
            this.ridgetObservable = new WritableValue(null, Date.class);
            this.ridgetObservable.addValueChangeListener(new IValueChangeListener(){

                public void handleValueChange(ValueChangeEvent event) {
                    Object oldValue = event.diff.getOldValue();
                    Object newValue = event.diff.getNewValue();
                    DateTimeRidget.this.firePropertyChange("date", oldValue, newValue);
                }
            });
        }
        return this.ridgetObservable;
    }

    public DateTime getUIControl() {
        return (DateTime)super.getUIControl();
    }

    public void bindToModel(IObservableValue observableValue) {
        this.unbindUIControl();
        Assert.isNotNull((Object)observableValue);
        super.bindToModel(observableValue);
        this.bindUIControl();
    }

    public void bindToModel(Object valueHolder, String valuePropertyName) {
        this.bindToModel(PojoObservables.observeValue((Object)valueHolder, (String)valuePropertyName));
    }

    public int getAlignment() {
        throw new UnsupportedOperationException();
    }

    public Date getDate() {
        return (Date)this.getRidgetObservable().getValue();
    }

    public String getText() {
        Date date = this.getDate();
        return date != null ? SimpleDateFormat.getInstance().format(date) : "";
    }

    public boolean isDirectWriting() {
        return true;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public boolean revalidate() {
        Date date = this.getDate();
        IStatus onUpdate = this.checkOnUpdateRules(date);
        this.validationRulesChecked(DateTimeRidget.suppressBlockWithFlash(onUpdate));
        if (onUpdate.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
        return !this.isErrorMarked();
    }

    public void setAlignment(int alignment) {
        throw new UnsupportedOperationException();
    }

    public void setDate(Date date) {
        this.getRidgetObservable().setValue((Object)date);
        if (this.controlBinding != null) {
            this.controlBinding.updateModelToTarget();
        }
        IStatus onEdit = this.checkOnEditRules(date);
        IStatus onUpdate = this.checkOnUpdateRules(date);
        IStatus status = DateTimeRidget.suppressBlockWithFlash(onEdit, onUpdate);
        this.validationRulesChecked(status);
        if (status.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
    }

    public void setDirectWriting(boolean directWriting) {
        throw new UnsupportedOperationException();
    }

    public void setText(String text) {
        throw new UnsupportedOperationException();
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.controlBinding != null) {
            this.controlBinding.updateModelToTarget();
        }
        IStatus onEdit = this.checkOnEditRules(this.getDate());
        IStatus onUpdate = this.checkOnUpdateRules(this.getDate());
        this.validationRulesChecked(DateTimeRidget.suppressBlockWithFlash(onEdit, onUpdate));
    }

    private Date getNonNullDate(Date date) {
        return date != null ? date : new Date(0L);
    }

    private boolean isTimeControl(DateTime control) {
        return (control.getStyle() & 0x80) != 0;
    }

    private void updateEditable() {
        DateTime control = this.getUIControl();
        if (control != null && !control.isDisposed()) {
            control.setEnabled(!this.isOutputOnly() && this.isEnabled());
        }
    }

    private final class DateAndTimeObservableWithNullConversion
    extends DateAndTimeObservableValue {
        public DateAndTimeObservableWithNullConversion(IObservableValue dateObservable, IObservableValue timeObservable) {
            super(dateObservable, timeObservable);
        }

        protected void doSetValue(Object value) {
            super.doSetValue((Object)DateTimeRidget.this.getNonNullDate((Date)value));
        }
    }

    private final class EditRulesValidator
    implements IValidator {
        private EditRulesValidator() {
        }

        public IStatus validate(Object value) {
            IStatus result = DateTimeRidget.this.getValueBindingSupport().getOnEditValidators().validate(value);
            DateTimeRidget.this.validationRulesChecked(result);
            return result;
        }
    }
}

