/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.core.marker.IMessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.marker.AbstractMessageMarkerViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TooltipMessageMarkerViewer
extends AbstractMessageMarkerViewer {
    private PropertyChangeListener markerPropertyChangeListener = new MarkerPropertyChangeListener();
    private HashMap<IBasicMarkableRidget, Tooltip> tooltips = new LinkedHashMap<IBasicMarkableRidget, Tooltip>();

    @Override
    public void addRidget(IBasicMarkableRidget markableRidget) {
        super.addRidget(markableRidget);
        markableRidget.addPropertyChangeListener(this.markerPropertyChangeListener);
    }

    @Override
    public void removeRidget(IBasicMarkableRidget markableRidget) {
        markableRidget.removePropertyChangeListener(this.markerPropertyChangeListener);
        super.removeRidget(markableRidget);
    }

    @Override
    protected void showMessages(IBasicMarkableRidget markableRidget) {
        Collection<IMessageMarker> messageMarker = this.getMessageMarker(markableRidget);
        String message = this.constructMessage(messageMarker);
        String current = markableRidget.getToolTipText();
        if (message.length() > 0 && this.isVisible()) {
            if (!message.equals(current)) {
                Tooltip tooltip = this.tooltips.get(markableRidget);
                if (tooltip == null) {
                    tooltip = new Tooltip(current, message);
                    this.tooltips.put(markableRidget, tooltip);
                } else {
                    tooltip.messageTooltip = message;
                }
                markableRidget.setToolTipText(message);
            }
        } else {
            this.hideMessages(markableRidget);
        }
    }

    @Override
    protected void hideMessages(IBasicMarkableRidget markableRidget) {
        if (this.tooltips.containsKey(markableRidget)) {
            String tooltip = this.tooltips.get(markableRidget).originalTooltip;
            markableRidget.setToolTipText(tooltip);
            this.tooltips.remove(markableRidget);
        }
    }

    private String constructMessage(Collection<IMessageMarker> messageMarker) {
        StringWriter sw = new StringWriter();
        IMessageMarker nextMarker2 = null;
        if (messageMarker != null) {
            for (IMessageMarker nextMarker2 : messageMarker) {
                if (sw.toString().trim().length() > 0) {
                    sw.write("; ");
                }
                if (nextMarker2.getMessage() == null) continue;
                sw.write(nextMarker2.getMessage());
            }
        }
        return sw.toString().trim();
    }

    private final class MarkerPropertyChangeListener
    implements PropertyChangeListener {
        private MarkerPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof IBasicMarkableRidget) {
                if ("marker".equals(evt.getPropertyName())) {
                    IBasicMarkableRidget ridget = (IBasicMarkableRidget)evt.getSource();
                    TooltipMessageMarkerViewer.this.showMessages(ridget);
                } else if ("tooltip".equals(evt.getPropertyName())) {
                    IBasicMarkableRidget ridget = (IBasicMarkableRidget)evt.getSource();
                    String newTooltip = (String)evt.getNewValue();
                    Tooltip tip = (Tooltip)TooltipMessageMarkerViewer.this.tooltips.get(ridget);
                    if (tip != null && !StringUtils.equals((CharSequence)newTooltip, (CharSequence)tip.originalTooltip)) {
                        TooltipMessageMarkerViewer.this.showMessages(ridget);
                        if (!StringUtils.equals((CharSequence)newTooltip, (CharSequence)tip.messageTooltip)) {
                            tip.originalTooltip = newTooltip;
                        }
                    }
                }
            }
        }
    }

    private static final class Tooltip {
        private String originalTooltip;
        private String messageTooltip;

        Tooltip(String originalTooltip, String messageTooltip) {
            this.originalTooltip = originalTooltip;
            this.messageTooltip = messageTooltip;
        }

        public String toString() {
            return String.format("[%s,%s]", this.originalTooltip, this.messageTooltip);
        }
    }
}

