/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.ridgets.validation.IValidationRuleStatus;

public final class ValidationRuleStatus
extends Status
implements IValidationRuleStatus {
    private IValidator source;

    private ValidationRuleStatus(int severity, int code, String message, IValidator source) {
        super(severity, "org.eclipse.riena.ui.internal.ridgets", code, message, null);
        this.source = source;
    }

    public IValidator getSource() {
        return this.source;
    }

    public static IStatus ok() {
        return Status.OK_STATUS;
    }

    public static IStatus error(boolean blocker, String message, IValidator source) {
        int code = 1025;
        if (blocker) {
            code = 1024;
        }
        return new ValidationRuleStatus(4, code, message, source);
    }

    public static IStatus join(IStatus[] statuses) {
        IStatus result;
        if (statuses.length == 1) {
            result = statuses[0];
        } else {
            int code = 1025;
            StringBuilder allMessages = new StringBuilder();
            IStatus[] iStatusArray = statuses;
            int n = statuses.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                if (status.getCode() == 1024) {
                    code = 1024;
                }
                if (!StringUtils.isDeepEmpty((String)status.getMessage())) {
                    allMessages.append(String.valueOf(status.getMessage()) + "\n");
                }
                ++n2;
            }
            String message = allMessages.length() == 0 ? null : allMessages.toString();
            result = new MultiStatus("org.eclipse.riena.ui.internal.ridgets", code, statuses, message, null);
        }
        return result;
    }
}

