/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.nebula.widgets.compositetable.CompositeTable;
import org.eclipse.swt.nebula.widgets.compositetable.IRowContentProvider;
import org.eclipse.swt.nebula.widgets.compositetable.IRowFocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;

public abstract class AbstractSelectableRow
extends Composite
implements TraverseListener,
FocusListener,
MouseListener,
IRowFocusListener,
IRowContentProvider,
KeyListener {
    private Display display = Display.getCurrent();
    private Color LIST_BACKGROUND = this.display.getSystemColor(25);
    private Color LIST_FOREGROUND = this.display.getSystemColor(24);
    private Color LIST_SELECTION = this.display.getSystemColor(26);
    private Color LIST_SELECTION_TEXT = this.display.getSystemColor(27);
    private Color LIST_SELECTION_NOFOCUS = this.display.getSystemColor(19);
    private Color LIST_SELECTION_TEXT_NOFOCUS = this.display.getSystemColor(24);
    protected List labels;
    private boolean selected = false;
    private boolean inactiveSelected = false;
    private Object model = null;
    private int columnCount = -1;

    public AbstractSelectableRow(Composite parent, int style) {
        super(parent, style);
        this.addTraverseListener(this);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    private void initialize() {
        this.labels = new ArrayList();
        int i = 0;
        while (i < this.getColumnCount()) {
            Label label = new Label((Composite)this, 0);
            this.labels.add(label);
            label.addMouseListener((MouseListener)this);
            ++i;
        }
    }

    public List getLabelsList() {
        return this.labels;
    }

    private void setRowColor(Color foreground, Color background) {
        this.setBackground(background);
        this.setForeground(foreground);
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setBackground(background);
            children[i].setForeground(foreground);
            ++i;
        }
    }

    public void keyTraversed(TraverseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this.setRowColor(this.LIST_SELECTION_TEXT, this.LIST_SELECTION);
        this.selected = true;
        this.setSelection(this.model);
    }

    protected void setSelection(Object model) {
    }

    public void focusLost(FocusEvent e) {
        if (this.selected) {
            this.setRowColor(this.LIST_SELECTION_TEXT_NOFOCUS, this.LIST_SELECTION_NOFOCUS);
            this.inactiveSelected = true;
        }
    }

    public void depart(CompositeTable sender, int currentObjectOffset, Control row) {
        if (row == this && this.selected) {
            this.deselectRow();
        }
    }

    public void arrive(CompositeTable sender, int currentObjectOffset, Control newRow) {
    }

    public void refresh(CompositeTable sender, int currentObjectOffset, Control row) {
        if (row == this && this.inactiveSelected) {
            this.deselectRow();
        }
    }

    private void deselectRow() {
        this.setRowColor(this.LIST_FOREGROUND, this.LIST_BACKGROUND);
        this.selected = false;
        this.inactiveSelected = false;
    }

    public boolean requestRowChange(CompositeTable sender, int currentObjectOffset, Control row) {
        return true;
    }

    public void mouseDown(MouseEvent e) {
        this.setFocus();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void setModel(Object object) {
        this.model = object;
    }

    public Object getModel() {
        return this.model;
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        for (Label label : this.labels) {
            label.setMenu(menu);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void setColumnCount(int columnCount) {
        if (this.columnCount > -1) {
            throw new IllegalArgumentException("Cannot setColumnCount more than once");
        }
        this.columnCount = columnCount;
        this.initialize();
        this.setRowColor(this.LIST_FOREGROUND, this.LIST_BACKGROUND);
    }

    private int getColumnCount() {
        return this.columnCount;
    }
}

