/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.nebula.widgets.compositetable;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.nebula.widgets.compositetable.InternalCompositeTable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class TableRow {
    private Control row;
    private Control[] columns;
    protected InternalCompositeTable parent;
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            TableRow.this.parent.keyPressed(TableRow.this, e);
        }
    };
    private FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent e) {
            TableRow.this.parent.focusLost(TableRow.this, e);
        }

        public void focusGained(FocusEvent e) {
            TableRow.this.parent.focusGained(TableRow.this, e);
        }
    };
    private TraverseListener traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent e) {
            if (e.doit) {
                TableRow.this.parent.keyTraversed(TableRow.this, e);
            }
        }
    };

    public TableRow(InternalCompositeTable parent, Control row) {
        this.parent = parent;
        this.row = row;
        if (row instanceof Composite) {
            Composite rowComposite = (Composite)row;
            this.columns = rowComposite.getTabList();
        } else {
            this.columns = new Control[]{row};
        }
        this.recursiveAddListeners(row);
    }

    public void dispose() {
        this.recursiveRemoveListeners(this.row);
    }

    private void recursiveAddListeners(Control c) {
        this.addListeners(c);
        if (c instanceof Composite) {
            Control[] children = ((Composite)c).getChildren();
            int i = 0;
            while (i < children.length) {
                this.recursiveAddListeners(children[i]);
                ++i;
            }
        }
    }

    private void recursiveRemoveListeners(Control c) {
        this.removeListeners(c);
        if (c instanceof Composite) {
            Control[] children = ((Composite)c).getChildren();
            int i = 0;
            while (i < children.length) {
                this.recursiveRemoveListeners(children[i]);
                ++i;
            }
        }
    }

    private void addListeners(Control control) {
        control.addKeyListener(this.keyListener);
        control.addFocusListener(this.focusListener);
        control.addTraverseListener(this.traverseListener);
    }

    private void removeListeners(Control control) {
        control.removeKeyListener(this.keyListener);
        control.removeFocusListener(this.focusListener);
        control.removeTraverseListener(this.traverseListener);
    }

    public Control getRowControl() {
        return this.row;
    }

    public Control getColumnControl(int i) {
        if (i < 0) {
            return this.row;
        }
        if (i < 1 && this.columns.length == 0) {
            return this.row;
        }
        if (i < this.columns.length) {
            return this.columns[i];
        }
        return null;
    }

    public int getColumnNumber(Control control) {
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i] == control) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getNumColumns() {
        return this.columns.length;
    }

    public void setVisible(boolean visible) {
        this.row.setVisible(visible);
    }

    public boolean getVisible() {
        return this.row.getVisible();
    }
}

