/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.internal.core.Activator;

public final class RienaStatus {
    public static final String RIENA_DEVELOPMENT_SYSTEM_PROPERTY = "riena.development";
    public static final String RIENA_TEST_SYSTEM_PROPERTY = "riena.test";
    public static final String DEVELOPMENT_DEFAULT = RienaStatus.inOsgiDevMode();
    public static final String TEST_DEFAULT = "false";
    public static final String UNKNOWN_STAGE = "<unknown>";

    private RienaStatus() {
    }

    public static boolean isActive() {
        if (Activator.getDefault() == null) {
            return false;
        }
        return Activator.getDefault().isActive();
    }

    public static boolean areStartupActionsExecuted() {
        return Activator.getDefault().areStartupActionsExecuted();
    }

    public static boolean isDevelopment() {
        return Boolean.parseBoolean(System.getProperty(RIENA_DEVELOPMENT_SYSTEM_PROPERTY, DEVELOPMENT_DEFAULT));
    }

    private static String inOsgiDevMode() {
        return Boolean.toString(System.getProperty("osgi.dev") != null);
    }

    public static boolean isTest() {
        return Boolean.parseBoolean(System.getProperty(RIENA_TEST_SYSTEM_PROPERTY, TEST_DEFAULT));
    }

    public static String getStage() {
        try {
            return VariableManagerUtil.substitute("${riena.stage}");
        }
        catch (CoreException coreException) {
            return UNKNOWN_STAGE;
        }
    }
}

