/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.exceptionmanager;

import java.util.List;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.injector.InjectionFailure;
import org.eclipse.riena.core.util.Orderer;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.exceptionmanager.IExceptionHandlerExtension;

public class SimpleExceptionHandlerManager
implements IExceptionHandlerManager {
    private List<IExceptionHandler> handlers;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SimpleExceptionHandlerManager.class);

    @InjectExtension
    public void update(IExceptionHandlerExtension[] exceptionHandlerExtensions) {
        Orderer<IExceptionHandler> orderer = new Orderer<IExceptionHandler>();
        IExceptionHandlerExtension[] iExceptionHandlerExtensionArray = exceptionHandlerExtensions;
        int n = exceptionHandlerExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionHandlerExtension extension = iExceptionHandlerExtensionArray[n2];
            orderer.add(extension.createExceptionHandler(), extension.getName(), extension.getPreHandlers(), this.getPostHandler(extension));
            ++n2;
        }
        this.handlers = orderer.getOrderedObjects();
    }

    private String getPostHandler(IExceptionHandlerExtension extension) {
        if (StringUtils.isGiven(extension.getBefore()) && StringUtils.isGiven(extension.getPostHandlers())) {
            throw new InjectionFailure("ExcetionHandler definition " + extension.getName() + "uses both the deprecated 'before' and new 'getPostHandler' attributes. Use only 'getPostHandler'");
        }
        if (StringUtils.isGiven(extension.getBefore())) {
            return extension.getBefore();
        }
        if (StringUtils.isGiven(extension.getPostHandlers())) {
            return extension.getPostHandlers();
        }
        return null;
    }

    public IExceptionHandler.Action handleException(Throwable t) {
        return this.handleException(t, null, LOGGER);
    }

    public IExceptionHandler.Action handleException(Throwable t, Logger logger) {
        return this.handleException(t, null, logger);
    }

    public IExceptionHandler.Action handleException(Throwable t, String msg) {
        return this.handleException(t, msg, LOGGER);
    }

    public IExceptionHandler.Action handleException(Throwable t, String msg, Logger logger) {
        for (IExceptionHandler handler : this.handlers) {
            try {
                IExceptionHandler.Action action = handler.handleException(t, msg, logger);
                if (action == IExceptionHandler.Action.NOT_HANDLED) continue;
                return action;
            }
            catch (Throwable t2) {
                LOGGER.log(1, "exception handler 'handle' method throws exception", t2);
            }
        }
        return IExceptionHandler.Action.NOT_HANDLED;
    }
}

