/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.injector.extension;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyExecutableExtension
implements InvocationHandler {
    private final BundleContext bundleContext;
    private final IConfigurationElement configurationElement;
    private final String attributeName;
    private final boolean wire;
    private volatile Object delegate;

    static Object newInstance(Class<?> returnType, IConfigurationElement configurationElement, String attributeName, boolean wire) {
        return Proxy.newProxyInstance(returnType.getClassLoader(), new Class[]{returnType}, (InvocationHandler)new LazyExecutableExtension(LazyExecutableExtension.getBundleContext(returnType), configurationElement, attributeName, wire));
    }

    private LazyExecutableExtension(BundleContext bundleContext, IConfigurationElement configurationElement, String attributeName, boolean wire) {
        this.bundleContext = bundleContext;
        this.configurationElement = configurationElement;
        this.attributeName = attributeName;
        this.wire = wire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object temp = this.delegate;
        if (temp == null) {
            LazyExecutableExtension lazyExecutableExtension = this;
            synchronized (lazyExecutableExtension) {
                temp = this.delegate;
                if (temp == null) {
                    Object temp2 = this.configurationElement.createExecutableExtension(this.attributeName);
                    if (this.wire) {
                        Wire.instance(temp2).andStart(this.bundleContext);
                    }
                    this.delegate = temp = temp2;
                }
            }
        }
        return method.invoke(this.delegate, args);
    }

    private static BundleContext getBundleContext(Class<?> returnType) {
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(returnType);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null) {
            return bundleContext;
        }
        return Activator.getDefault().getContext();
    }
}

