/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.IModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleGroupNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.navigation.ui.swt.ApplicationUtility;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.EmbeddedBorderRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleViewRenderer;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.INavigationCompositeDelegation;
import org.eclipse.riena.navigation.ui.swt.views.IViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewFactory;
import org.eclipse.riena.navigation.ui.swt.views.NodeIdentificationSupport;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.navigation.ui.swt.views.ScrollBarNavigationCompositeDeligation;
import org.eclipse.riena.navigation.ui.swt.views.ScrollButtonsNavigationCompositeDeligation;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

public class NavigationViewPart
extends ViewPart
implements IModuleNavigationComponentProvider {
    public static final String ID = "org.eclipse.riena.navigation.ui.swt.views.navigationViewPart";
    private static final Color NAVIGATION_BACKGROUND = LnfManager.getLnf().getColor("Navigation.background");
    private IViewFactory viewFactory;
    private Composite parent;
    private ResizeListener resizeListener;
    private final List<ModuleGroupView> moduleGroupViews = new ArrayList<ModuleGroupView>();
    private Composite navigationMainComposite;
    private INavigationCompositeDelegation navigationCompositeDelegation;
    private NavigationTreeObserver navigationTreeObserver;
    private final Map<INavigationNode<?>, ModuleGroupView> moduleGroupNodesToViews;
    private final Map<INavigationNode<?>, ModuleView> moduleNodesToViews;

    public NavigationViewPart() {
        this.markAsNavigation();
        this.moduleGroupNodesToViews = new HashMap();
        this.moduleNodesToViews = new HashMap();
    }

    protected IViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new NavigationViewFactory();
            Wire.instance((Object)this.viewFactory).andStart(Activator.getDefault().getContext());
        }
        return this.viewFactory;
    }

    private void markAsNavigation() {
        this.setPartProperty("navigation", String.valueOf(Boolean.TRUE));
    }

    public ISubApplicationNode getSubApplicationNode() {
        String perspectiveID = this.getViewSite().getPage().getPerspective().getId();
        return SwtViewProvider.getInstance().getNavigationNode(perspectiveID, ISubApplicationNode.class);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        this.initLayoutParts();
        this.buildNavigationViewHierarchy();
        this.initModelObserver();
        parent.setData("subapplication.node", (Object)this.getSubApplicationNode());
    }

    private void initLayoutParts() {
        this.parent.setLayout((Layout)new FormLayout());
        this.parent.setBackground(NAVIGATION_BACKGROUND);
        this.resizeListener = new ResizeListener();
        this.parent.addControlListener((ControlListener)this.resizeListener);
        this.navigationMainComposite = new Composite(this.parent, 0x20000000);
        this.navigationMainComposite.setLayout((Layout)new FormLayout());
        this.navigationMainComposite.setBackground(NAVIGATION_BACKGROUND);
        this.navigationCompositeDelegation = this.createNavigationCompositeDelegation(this.parent, this.navigationMainComposite);
        boolean fastView = ApplicationUtility.isNavigationFastViewEnabled();
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, fastView ? 3 : 0);
        formData.left = new FormAttachment(0, fastView ? 3 : 0);
        formData.right = new FormAttachment(100, fastView ? -3 : 0);
        formData.bottom = new FormAttachment(100, this.navigationCompositeDelegation.getBottomOffest() - (fastView ? 3 : 0));
        this.navigationMainComposite.setLayoutData((Object)formData);
        if (fastView) {
            SWTFacade.getDefault().addPaintListener((Control)this.parent, (EventListener)new PaintListener(){

                public void paintControl(PaintEvent e) {
                    SubModuleViewRenderer viewRenderer = (SubModuleViewRenderer)LnfManager.getLnf().getRenderer("SubModuleView.renderer");
                    if (viewRenderer != null) {
                        Rectangle bounds = NavigationViewPart.this.parent.getBounds();
                        viewRenderer.setBounds(bounds);
                        viewRenderer.paint(e.gc, null);
                    }
                }
            });
        }
    }

    private INavigationCompositeDelegation createNavigationCompositeDelegation(Composite superParent, Composite parent) {
        boolean scrollBar = LnfManager.getLnf().getBooleanSetting("navigation.scroll.bar", false);
        if (scrollBar) {
            return new ScrollBarNavigationCompositeDeligation(superParent, parent, this);
        }
        return new ScrollButtonsNavigationCompositeDeligation(superParent, parent, this);
    }

    public void dispose() {
        super.dispose();
        if (!SwtUtilities.isDisposed((Widget)this.parent) && this.resizeListener != null) {
            this.parent.removeControlListener((ControlListener)this.resizeListener);
        }
    }

    private void buildNavigationViewHierarchy() {
        ISubApplicationNode subApplicationNode = this.getSubApplicationNode();
        for (IModuleGroupNode moduleGroupNode : subApplicationNode.getChildren()) {
            this.createModuleGroupView(moduleGroupNode);
        }
        this.updateNavigationSize();
    }

    private void initModelObserver() {
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((ISubApplicationNodeListener)new SubApplicationListener());
        this.navigationTreeObserver.addListener((IModuleGroupNodeListener)new ModuleGroupListener());
        this.navigationTreeObserver.addListener((IModuleNodeListener)new ModuleListener());
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.navigationTreeObserver.addListenerTo(this.getSubApplicationNode());
    }

    public ModuleGroupView getModuleGroupViewForNode(IModuleGroupNode source) {
        return this.moduleGroupNodesToViews.get(source);
    }

    public ModuleView getModuleViewForNode(IModuleNode source) {
        return this.moduleNodesToViews.get(source);
    }

    private void createModuleGroupView(IModuleGroupNode moduleGroupNode) {
        ModuleGroupView moduleGroupView = this.getViewFactory().createModuleGroupView(this.navigationCompositeDelegation.getNavigationComposite());
        NodeIdentificationSupport.setIdentification((Widget)moduleGroupView, "moduleGroupView", (INavigationNode)moduleGroupNode);
        this.moduleGroupNodesToViews.put((INavigationNode<?>)moduleGroupNode, moduleGroupView);
        moduleGroupView.addUpdateListener(new ModuleGroupViewObserver());
        this.registerModuleGroupView(moduleGroupView);
        this.getViewFactory().createModuleGroupController(moduleGroupNode);
        moduleGroupView.bind((ModuleGroupNode)moduleGroupNode);
        moduleGroupView.setLayout((Layout)new FormLayout());
        Composite moduleGroupBody = new Composite((Composite)moduleGroupView, 0);
        moduleGroupBody.setBackground(LnfManager.getLnf().getColor("ModuleGroupWidget.background"));
        FormData formData = new FormData();
        int padding = this.getModuleGroupPadding();
        formData.top = new FormAttachment(0, padding);
        formData.left = new FormAttachment(0, padding);
        formData.bottom = new FormAttachment(100, -padding);
        formData.right = new FormAttachment(100, -padding);
        moduleGroupBody.setLayoutData((Object)formData);
        for (IModuleNode moduleNode : moduleGroupNode.getChildren()) {
            this.createModuleView(moduleNode, moduleGroupView);
        }
    }

    private void registerModuleGroupView(ModuleGroupView moduleGroupView) {
        this.moduleGroupViews.add(moduleGroupView);
        ModuleGroupViewComparator comparator = new ModuleGroupViewComparator();
        Collections.sort(this.moduleGroupViews, comparator);
    }

    public void unregisterModuleGroupView(IModuleGroupNode moduleGroupNode) {
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            if (moduleGroupView.getNavigationNode() != moduleGroupNode) continue;
            this.unregisterModuleGroupView(moduleGroupView, moduleGroupNode);
            break;
        }
    }

    private void unregisterModuleGroupView(ModuleGroupView moduleGroupView, IModuleGroupNode node) {
        this.moduleGroupNodesToViews.remove(node);
        this.moduleGroupViews.remove(moduleGroupView);
    }

    private void replaceNavigationNodeId(IModuleGroupNode node, NavigationNodeId oldId, NavigationNodeId newId) {
        node.setNodeId(oldId);
        ModuleGroupView view = this.moduleGroupNodesToViews.remove(node);
        if (view != null) {
            node.setNodeId(newId);
            this.moduleGroupNodesToViews.put((INavigationNode<?>)node, view);
        }
    }

    private void replaceNavigationNodeId(IModuleNode node, NavigationNodeId oldId, NavigationNodeId newId) {
        node.setNodeId(oldId);
        ModuleView view = this.moduleNodesToViews.remove(node);
        if (view != null) {
            node.setNodeId(newId);
            this.moduleNodesToViews.put((INavigationNode<?>)node, view);
        }
    }

    private void createModuleView(IModuleNode moduleNode, ModuleGroupView moduleGroupView) {
        Composite moduleGroupBody = (Composite)moduleGroupView.getChildren()[0];
        FormLayout layout = new FormLayout();
        moduleGroupBody.setLayout((Layout)layout);
        ModuleView moduleView = this.viewFactory.createModuleView(moduleGroupBody);
        moduleView.setModuleGroupNode(moduleGroupView.getNavigationNode());
        NodeIdentificationSupport.setIdentification((Widget)moduleView.getTitle(), "titleBar", (INavigationNode)moduleNode);
        NodeIdentificationSupport.setIdentification((Widget)moduleView.getTree(), "tree", (INavigationNode)moduleNode);
        this.moduleNodesToViews.put((INavigationNode<?>)moduleNode, moduleView);
        ModuleController controller = this.getViewFactory().createModuleController(moduleNode);
        moduleView.bind((ModuleNode)moduleNode);
        if (controller instanceof SWTModuleController) {
            ((SWTModuleController)controller).getTree().addSelectionListener(new ISelectionListener(){

                public void ridgetSelected(SelectionEvent event) {
                    NavigationViewPart.this.navigationCompositeDelegation.scroll();
                }
            });
        }
        moduleGroupView.registerModuleView(moduleView);
    }

    public void updateNavigationSize() {
        int height = this.calculateBounds();
        this.navigationCompositeDelegation.getNavigationComposite().layout();
        this.navigationMainComposite.layout();
        if (this.navigationMainComposite.getBounds().height == 0) {
            height = 0;
        }
        this.navigationCompositeDelegation.updateSize(height);
        boolean widthChanged = this.updateModuleGroupWidth(height);
        if (widthChanged) {
            this.updateNavigationSize();
        } else {
            this.navigationMainComposite.layout(true, true);
            this.navigationMainComposite.getParent().layout(true, true);
        }
        this.navigationCompositeDelegation.scroll();
    }

    private boolean updateModuleGroupWidth(int height) {
        boolean widthChanged = false;
        int scrollbarWidth = 0;
        if (height > this.navigationMainComposite.getBounds().height) {
            scrollbarWidth = this.navigationCompositeDelegation.getVerticalScrollBarSize().x;
        }
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            if (moduleGroupView.getScrollbarWidth() == scrollbarWidth) continue;
            moduleGroupView.setScrollbarWidth(scrollbarWidth);
            widthChanged = true;
        }
        return widthChanged;
    }

    public IModuleGroupNode getActiveModuleGroupNode() {
        List children = this.getSubApplicationNode().getChildren();
        for (IModuleGroupNode child : children) {
            if (!child.isActivated()) continue;
            return child;
        }
        return null;
    }

    public int calculateBounds() {
        int yPosition = 0;
        Collections.sort(this.moduleGroupViews, new ModuleGroupViewComparator());
        for (ModuleGroupView moduleGroupView : this.moduleGroupViews) {
            yPosition = moduleGroupView.calculateBounds(yPosition);
        }
        return yPosition;
    }

    private ModuleGroupRenderer getModuleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private EmbeddedBorderRenderer getLnfBorderRenderer() {
        EmbeddedBorderRenderer renderer = (EmbeddedBorderRenderer)LnfManager.getLnf().getRenderer("SubModuleView.borderRenderer");
        if (renderer == null) {
            renderer = new EmbeddedBorderRenderer();
        }
        return renderer;
    }

    private int getModuleGroupPadding() {
        return this.getModuleGroupRenderer().getModuleGroupPadding() + this.getLnfBorderRenderer().getBorderWidth();
    }

    public void setFocus() {
        this.navigationMainComposite.setFocus();
    }

    public Composite getNavigationComponent() {
        return this.navigationMainComposite;
    }

    public Composite getScrolledComponent() {
        return this.navigationCompositeDelegation.getNavigationComposite();
    }

    private class ModuleGroupListener
    extends ModuleGroupNodeListener {
        private ModuleGroupListener() {
        }

        public void childAdded(IModuleGroupNode source, IModuleNode child) {
            ModuleGroupView moduleGroupView = NavigationViewPart.this.getModuleGroupViewForNode(source);
            NavigationViewPart.this.createModuleView(child, moduleGroupView);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(IModuleGroupNode source, IModuleNode child) {
            NavigationViewPart.this.moduleNodesToViews.remove(child);
        }

        public void disposed(IModuleGroupNode source) {
            super.disposed((INavigationNode)source);
            NavigationViewPart.this.unregisterModuleGroupView(source);
        }

        public void markerChanged(IModuleGroupNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }

        public void nodeIdChange(IModuleGroupNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange((INavigationNode)source, oldId, newId);
            NavigationViewPart.this.replaceNavigationNodeId(source, oldId, newId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModuleGroupViewComparator
    implements Comparator<ModuleGroupView> {
        ModuleGroupViewComparator() {
        }

        @Override
        public int compare(ModuleGroupView moduleGroupView1, ModuleGroupView moduleGroupView2) {
            ModuleGroupNode moduleGroupNode1 = moduleGroupView1.getNavigationNode();
            ModuleGroupNode moduleGroupNode2 = moduleGroupView2.getNavigationNode();
            return NavigationViewPart.this.getSubApplicationNode().getIndexOfChild((INavigationNode)moduleGroupNode1) < NavigationViewPart.this.getSubApplicationNode().getIndexOfChild((INavigationNode)moduleGroupNode2) ? -1 : 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ModuleGroupViewObserver
    implements IComponentUpdateListener {
        private ModuleGroupViewObserver() {
        }

        @Override
        public void update(INavigationNode<?> node) {
            NavigationViewPart.this.updateNavigationSize();
        }
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void nodeIdChange(IModuleNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            super.nodeIdChange((INavigationNode)source, oldId, newId);
            NavigationViewPart.this.replaceNavigationNodeId(source, oldId, newId);
        }
    }

    private final class ResizeListener
    extends ControlAdapter {
        private ResizeListener() {
        }

        public void controlResized(ControlEvent e) {
            NavigationViewPart.this.parent.layout();
            NavigationViewPart.this.updateNavigationSize();
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void childAdded(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.createModuleGroupView(child);
            NavigationViewPart.this.updateNavigationSize();
        }

        public void childRemoved(ISubApplicationNode source, IModuleGroupNode child) {
            NavigationViewPart.this.unregisterModuleGroupView(child);
            if (source.isSelected()) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }

        public void markerChanged(ISubApplicationNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void markerChanged(ISubModuleNode source, IMarker marker) {
            if (marker instanceof HiddenMarker) {
                NavigationViewPart.this.updateNavigationSize();
            }
        }
    }
}

