/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.ui.ridgets.swt.uiprocess.UIProcessRidget;
import org.eclipse.riena.navigation.ApplicationModelFailure;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.INavigationNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubApplicationNodeListener;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubApplicationController;
import org.eclipse.riena.navigation.ui.swt.binding.DelegatingRidgetMapper;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.MenuCoolBarComposite;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewId;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SubModuleView;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.ridgets.uibinding.DefaultBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingManager;
import org.eclipse.riena.ui.ridgets.uibinding.IBindingPropertyLocator;
import org.eclipse.riena.ui.ridgets.uibinding.IControlRidgetMapper;
import org.eclipse.riena.ui.swt.uiprocess.UIProcessControl;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubApplicationView
implements INavigationNodeView<SubApplicationNode>,
IPerspectiveFactory {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubApplicationView.class);
    private final AbstractViewBindingDelegate binding = this.createBinding();
    private SubApplicationController subApplicationController;
    private SubApplicationListener subApplicationListener;
    private SubApplicationNode subApplicationNode;
    private final List<Object> uiControls = new ArrayList<Object>();
    private static IBindingManager menuItemBindingManager;
    private static int itemId;

    static {
        itemId = 0;
    }

    public SubApplicationView() {
        if (menuItemBindingManager == null) {
            menuItemBindingManager = this.createMenuItemBindingManager((IBindingPropertyLocator)SWTBindingPropertyLocator.getInstance(), (IControlRidgetMapper<Object>)SwtControlRidgetMapper.getInstance());
        }
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SubApplicationNode node) {
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)node.getNavigationNodeController();
            this.binding.injectRidgets(controller);
            this.binding.bind(controller);
            this.bindMenuAndToolItems(controller);
            controller.afterBind();
        }
        this.subApplicationListener = new SubApplicationListener();
        this.getNavigationNode().addListener((INavigationNodeListener)this.subApplicationListener);
    }

    public void createInitialLayout(IPageLayout layout) {
        this.addUIControls();
        this.subApplicationNode = (SubApplicationNode)this.locateSubApplication(layout);
        this.subApplicationController = this.createController((ISubApplicationNode)this.subApplicationNode);
        this.initializeListener(this.subApplicationController);
        this.bind(this.subApplicationNode);
        this.subApplicationController.afterBind();
        this.doBaseLayout(layout);
    }

    @Override
    public SubApplicationNode getNavigationNode() {
        return this.subApplicationNode;
    }

    @Override
    public void unbind() {
        if (this.getNavigationNode() != null) {
            this.getNavigationNode().removeListener((INavigationNodeListener)this.subApplicationListener);
            if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
                IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
                this.binding.unbind(controller);
                if (menuItemBindingManager != null) {
                    menuItemBindingManager.unbind((IRidgetContainer)controller, this.getUIControls());
                }
            }
        }
    }

    protected AbstractViewBindingDelegate createBinding() {
        DelegatingRidgetMapper ridgetMapper = new DelegatingRidgetMapper(SwtControlRidgetMapper.getInstance());
        this.addMappings(ridgetMapper);
        return new InjectSwtViewBindingDelegate(ridgetMapper);
    }

    protected SubApplicationController createController(ISubApplicationNode subApplication) {
        return new SubApplicationController(subApplication);
    }

    protected void doBaseLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(false);
        layout.setFixed(true);
    }

    private void addMappings(DelegatingRidgetMapper ridgetMapper) {
        ridgetMapper.addMapping(UIProcessControl.class, UIProcessRidget.class);
    }

    private void addUIControls() {
        this.initUIProcessRidget();
    }

    private void bindMenuAndToolItems(IController controller) {
        this.createRidgets(controller);
        menuItemBindingManager.bind((IRidgetContainer)controller, this.getUIControls());
    }

    private IBindingManager createMenuItemBindingManager(IBindingPropertyLocator propertyStrategy, IControlRidgetMapper<Object> mapper) {
        return new DefaultBindingManager(propertyStrategy, mapper);
    }

    private void createRidget(IController controller, Item item) {
        if (this.isSeparator(item)) {
            return;
        }
        String id = item instanceof MenuItem ? this.getItemId((MenuItem)item) : this.getItemId((ToolItem)item);
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        IRidget ridget = menuItemBindingManager.createRidget((Object)item);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)item, id);
        this.getUIControls().add(item);
        controller.addRidget(id, ridget);
        if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            this.createRidget(controller, menuItem.getMenu());
        }
    }

    private void createRidget(IController controller, Menu menu) {
        MenuItem[] items;
        if (menu == null) {
            return;
        }
        MenuItem[] menuItemArray = items = menu.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem item = menuItemArray[n2];
            this.createRidget(controller, (Item)item);
            ++n2;
        }
    }

    private void createRidgets(IController controller) {
        List<MenuCoolBarComposite> menuCoolBarComposites = this.getMenuCoolBarComposites((Composite)this.getShell());
        for (MenuCoolBarComposite menuBarComp : menuCoolBarComposites) {
            this.createRidgetsForItems(menuBarComp.getTopLevelItems(), controller);
        }
        List<ToolItem> toolItems = this.getAllToolItems();
        for (ToolItem toolItem : toolItems) {
            this.createRidget(controller, (Item)toolItem);
        }
    }

    private void createRidgetsForItems(List<ToolItem> toolItems, IController controller) {
        for (ToolItem toolItem : toolItems) {
            if (SWTBindingPropertyLocator.getInstance().hasBindingProperty((Object)toolItem)) continue;
            this.createRidget(controller, (Item)toolItem);
            if (!(toolItem.getData() instanceof MenuManager)) continue;
            MenuManager manager = (MenuManager)toolItem.getData();
            this.createRidget(controller, manager.getMenu());
        }
    }

    private List<ToolItem> getAllToolItems() {
        ArrayList<ToolItem> items = new ArrayList<ToolItem>();
        List<CoolBar> coolBars = this.getCoolBars((Composite)this.getShell());
        for (CoolBar coolBar : coolBars) {
            List<ToolBar> toolBars = this.getToolBars(coolBar);
            for (ToolBar toolBar : toolBars) {
                items.addAll(Arrays.asList(toolBar.getItems()));
            }
        }
        return items;
    }

    private List<CoolBar> getCoolBars(Composite composite) {
        Control[] children;
        ArrayList<CoolBar> coolBars = new ArrayList<CoolBar>();
        if (composite == null) {
            return coolBars;
        }
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof CoolBar) {
                if (this.getParentOfType(child, MenuCoolBarComposite.class) == null) {
                    coolBars.add((CoolBar)child);
                }
            } else if (child instanceof Composite) {
                coolBars.addAll(this.getCoolBars((Composite)child));
            }
            ++n2;
        }
        return coolBars;
    }

    private String getItemId(Item item, String prefix) {
        String id = null;
        if (item.getData() instanceof IContributionItem) {
            IContributionItem contributionItem = (IContributionItem)item.getData();
            id = contributionItem.getId();
        }
        if (StringUtils.isEmpty(id)) {
            id = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)item);
        }
        if (StringUtils.isEmpty(id)) {
            id = Integer.toString(++itemId);
        } else if (!id.startsWith(prefix)) {
            id = String.valueOf(prefix) + id;
        }
        return id;
    }

    private String getItemId(MenuItem item) {
        return this.getItemId((Item)item, "menuAction.");
    }

    private String getItemId(ToolItem item) {
        return this.getItemId((Item)item, "toolbarAction.");
    }

    private List<MenuCoolBarComposite> getMenuCoolBarComposites(Composite composite) {
        Control[] children;
        ArrayList<MenuCoolBarComposite> composites = new ArrayList<MenuCoolBarComposite>();
        Control[] controlArray = children = composite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof MenuCoolBarComposite) {
                composites.add((MenuCoolBarComposite)child);
            } else if (child instanceof Composite) {
                composites.addAll(this.getMenuCoolBarComposites((Composite)child));
            }
            ++n2;
        }
        return composites;
    }

    private Composite getParentOfType(Control control, Class<? extends Control> clazz) {
        Composite parent = control.getParent();
        if (parent == null) {
            return null;
        }
        if (clazz.isAssignableFrom(parent.getClass())) {
            return parent;
        }
        return this.getParentOfType((Control)parent, clazz);
    }

    private Shell getShell() {
        Shell[] shells;
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        Shell[] shellArray = shells = Display.getDefault().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            String value = locator.locateBindingProperty((Object)shell);
            if (value != null && value.equals("applicationWindow")) {
                return shell;
            }
            ++n2;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return Display.getDefault().getActiveShell();
    }

    private List<ToolBar> getToolBars(CoolBar coolBar) {
        Control[] children;
        ArrayList<ToolBar> toolBars = new ArrayList<ToolBar>();
        if (coolBar == null) {
            return toolBars;
        }
        Control[] controlArray = children = coolBar.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof ToolBar && this.getParentOfType(child, MenuCoolBarComposite.class) == null) {
                toolBars.add((ToolBar)child);
            }
            ++n2;
        }
        return toolBars;
    }

    private List<Object> getUIControls() {
        return this.uiControls;
    }

    private void initializeListener(SubApplicationController controller) {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((ISubModuleNodeListener)new MySubModuleNodeListener());
        navigationTreeObserver.addListenerTo((ISubApplicationNode)controller.getNavigationNode());
    }

    private void initUIProcessRidget() {
        UIProcessControl uiControl = new UIProcessControl(this.getShell());
        uiControl.setPropertyName("uiProcessRidget");
        this.binding.addUIControl((Object)uiControl);
    }

    private boolean isSeparator(Item item) {
        return (item.getStyle() & 2) == 2;
    }

    protected ISubApplicationNode locateSubApplication(IPageLayout layout) {
        return SwtViewProvider.getInstance().getNavigationNode(layout.getDescriptor().getId(), ISubApplicationNode.class);
    }

    protected int getViewUserCount(SwtViewId id) {
        return SwtViewProvider.getInstance().getViewUsers(id).size();
    }

    protected SwtViewId getViewId(ISubModuleNode node) {
        return SwtViewProvider.getInstance().getSwtViewId((INavigationNode<?>)node);
    }

    private IWorkbenchPage getActivePage() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private IPerspectiveDescriptor getActivePerspective() {
        IWorkbenchPage page = this.getActivePage();
        if (page != null) {
            return page.getPerspective();
        }
        return null;
    }

    private void hideView(String id, String secondary) {
        IViewReference viewRef = this.getActivePage().findViewReference(id, secondary);
        if (viewRef != null) {
            IViewPart view = viewRef.getView(false);
            if (view instanceof INavigationNodeView) {
                ((INavigationNodeView)view).unbind();
            }
            this.getActivePage().hideView(view);
        }
    }

    protected void hideView(SwtViewId id) {
        this.hideView(id.getId(), id.getSecondary());
    }

    private void showView(SwtViewId id) {
        this.showView(id.getId(), id.getSecondary());
    }

    private void showView(String id, String secondary) {
        IWorkbenchPage page = this.getActivePage();
        IViewReference viewRef = page.findViewReference(id, secondary);
        if (viewRef != null) {
            ((WorkbenchPage)page).getActivePerspective().bringToTop(viewRef);
        }
    }

    private IViewReference prepareView(SwtViewId id, ISubModuleNode currentPrepared) {
        return this.prepareView(id.getId(), id.getSecondary(), currentPrepared);
    }

    private IPerspectiveDescriptor getPerspectiveOfSubApplication(ISubApplicationNode subApp) {
        IPerspectiveDescriptor[] perspectives;
        Object subAppIdObject = WorkareaManager.getInstance().getDefinition((Object)this.getNavigationNode()).getViewId();
        String subAppId = String.valueOf(subAppIdObject);
        IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
        int n = perspectives.length;
        int n2 = 0;
        while (n2 < n) {
            IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
            if (StringUtils.equals((CharSequence)subAppId, (CharSequence)perspective.getId())) {
                return perspective;
            }
            ++n2;
        }
        return null;
    }

    private IViewReference prepareView(String id, String secondary, ISubModuleNode currentPrepared) {
        try {
            IWorkbenchPage page = this.getActivePage();
            SubModuleView viewPart = null;
            if ("shared".equals(secondary)) {
                viewPart = SwtViewProvider.getInstance().getRegisteredView(id);
            }
            if (viewPart == null) {
                IPerspectiveDescriptor activePerspective = this.getActivePerspective();
                IPerspectiveDescriptor subAppPerspective = this.getPerspectiveOfSubApplication((ISubApplicationNode)this.getNavigationNode());
                if (subAppPerspective != null) {
                    page.setPerspective(subAppPerspective);
                } else {
                    LOGGER.log(2, "No perspective found for sub application: " + this.getNavigationNode());
                }
                viewPart = page.showView(id, secondary, 2);
                if (subAppPerspective != null) {
                    page.setPerspective(activePerspective);
                }
            }
            if (currentPrepared != null && currentPrepared.getNavigationNodeController() == null && viewPart instanceof SubModuleView) {
                viewPart.prepareNode((SubModuleNode)currentPrepared);
            }
            return page.findViewReference(id, secondary);
        }
        catch (PartInitException exc) {
            String msg = String.format("Failed to prepare/show view: %s, %s", id, secondary);
            LOGGER.log(0, msg, (Throwable)exc);
            return null;
        }
    }

    private class MySubModuleNodeListener
    extends SubModuleNodeListener {
        private boolean navigationUp = false;

        private MySubModuleNodeListener() {
        }

        public void prepared(ISubModuleNode source) {
            this.checkBaseStructure();
            SwtViewId id = SubApplicationView.this.getViewId(source);
            SwtViewProvider viewProvider = SwtViewProvider.getInstance();
            viewProvider.setCurrentPrepared((INavigationNode<?>)source);
            SubApplicationView.this.prepareView(id, source);
            viewProvider.setCurrentPrepared(null);
        }

        public void afterActivated(ISubModuleNode source) {
            List menuCoolBarComposites = SubApplicationView.this.getMenuCoolBarComposites((Composite)SubApplicationView.this.getShell());
            for (MenuCoolBarComposite menuBarComp : menuCoolBarComposites) {
                List<ToolItem> changedItems = menuBarComp.updateMenuItems();
                if (changedItems.isEmpty()) continue;
                IController controller = (IController)SubApplicationView.this.getNavigationNode().getNavigationNodeController();
                SubApplicationView.this.createRidgets(controller);
                menuItemBindingManager.bind((IRidgetContainer)controller, SubApplicationView.this.getUIControls());
            }
        }

        public void activated(ISubModuleNode source) {
            this.checkBaseStructure();
            if (source != null && !source.isSelectable()) {
                return;
            }
            SwtViewId id = SubApplicationView.this.getViewId(source);
            SubApplicationView.this.prepareView(id, null);
            SubApplicationView.this.showView(id);
        }

        public void disposed(ISubModuleNode source) {
            block3: {
                try {
                    SwtViewId id = SubApplicationView.this.getViewId(source);
                    if (!"shared".equals(id.getSecondary()) || SubApplicationView.this.getViewUserCount(id) < 1) {
                        SubApplicationView.this.hideView(id);
                    }
                    SwtViewProvider viewProvider = SwtViewProvider.getInstance();
                    viewProvider.unregisterSwtViewId((INavigationNode<?>)source);
                }
                catch (ApplicationModelFailure amf) {
                    if (!source.isSelectable()) break block3;
                    LOGGER.log(1, "Error disposing node " + source + ": " + amf.getMessage());
                }
            }
        }

        protected String createNextId() {
            return String.valueOf(System.currentTimeMillis());
        }

        private void checkBaseStructure() {
            if (!this.navigationUp) {
                this.createNavigation();
                this.navigationUp = true;
            }
        }

        private void createNavigation() {
            String secId = this.createNextId();
            SubApplicationView.this.prepareView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart", secId, null);
            SubApplicationView.this.showView("org.eclipse.riena.navigation.ui.swt.views.navigationViewPart", secId);
        }
    }

    private class SubApplicationListener
    extends SubApplicationNodeListener {
        private SubApplicationListener() {
        }

        public void block(ISubApplicationNode source, boolean block) {
            super.block((INavigationNode)source, block);
            for (IModuleGroupNode group : source.getChildren()) {
                for (IModuleNode module : group.getChildren()) {
                    module.setBlocked(block);
                }
            }
        }

        public void disposed(ISubApplicationNode source) {
            SubApplicationView.this.unbind();
        }

        public void nodeIdChange(ISubApplicationNode source, NavigationNodeId oldId, NavigationNodeId newId) {
            if (source.equals(SubApplicationView.this.getNavigationNode())) {
                SwtViewProvider.getInstance().replaceNavigationNodeId((INavigationNode<?>)source, oldId, newId);
            }
        }
    }
}

