/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.IAssemblerProvider;
import org.eclipse.riena.navigation.IGenericNavigationAssembler;
import org.eclipse.riena.navigation.INavigationAssembler;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.NodePositioner;
import org.eclipse.riena.navigation.StartupNodeInfo;
import org.eclipse.riena.navigation.extension.ICommonNavigationAssemblyExtension;
import org.eclipse.riena.navigation.extension.INavigationAssembly2Extension;
import org.eclipse.riena.navigation.extension.INode2Extension;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.GenericNavigationAssembler;
import org.eclipse.riena.navigation.model.RunAsync;
import org.eclipse.riena.ui.core.uiprocess.UIExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSimpleNavigationNodeProvider
implements INavigationNodeProvider,
IAssemblerProvider {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), AbstractSimpleNavigationNodeProvider.class);
    private static Random random = null;
    private final Map<String, INavigationAssembler> assemblyId2AssemblerCache = new HashMap<String, INavigationAssembler>();

    @Override
    public List<StartupNodeInfo> getSortedStartupNodeInfos() {
        ArrayList<StartupNodeInfo> startups = new ArrayList<StartupNodeInfo>();
        for (INavigationAssembler assembler : this.getNavigationAssemblers()) {
            StartupNodeInfo startupNodeInfo;
            if (assembler.getStartOrder() <= 0 || (startupNodeInfo = this.createStartupSortable(assembler, assembler.getStartOrder())) == null) continue;
            startups.add(startupNodeInfo);
        }
        Collections.sort(startups);
        return startups;
    }

    private StartupNodeInfo createStartupSortable(INavigationAssembler assembler, Integer sequence) {
        INavigationAssembly2Extension assembly = assembler.getAssembly();
        if (assembly == null) {
            return null;
        }
        String id = this.getTypeId(assembly.getSubApplications());
        if (id != null) {
            return new StartupNodeInfo(StartupNodeInfo.Level.SUBAPPLICATION, sequence, id);
        }
        id = this.getTypeId(assembly.getModuleGroups());
        if (id != null) {
            return new StartupNodeInfo(StartupNodeInfo.Level.MODULEGROUP, sequence, id);
        }
        id = this.getTypeId(assembly.getModules());
        if (id != null) {
            return new StartupNodeInfo(StartupNodeInfo.Level.MODULE, sequence, id);
        }
        id = this.getTypeId(assembly.getSubModules());
        if (id != null) {
            return new StartupNodeInfo(StartupNodeInfo.Level.SUBMODULE, sequence, id);
        }
        id = assembler.getId();
        Assert.isNotNull((Object)assembly.getNavigationAssembler(), (String)("Assembly '" + id + "' must have an assembler specified since no immediate child has a typeId."));
        if (id != null) {
            return new StartupNodeInfo(StartupNodeInfo.Level.CUSTOM, sequence, id);
        }
        return null;
    }

    private String getTypeId(INode2Extension[] extensions) {
        if (extensions != null && extensions.length > 0) {
            return extensions[0].getNodeId();
        }
        return null;
    }

    @Override
    public INavigationNode<?> provideNode(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        return this.provideNodeHook(sourceNode, targetId, argument);
    }

    protected INavigationNode<?> provideNodeHook(INavigationNode<?> sourceNode, final NavigationNodeId targetId, final NavigationArgument argument) {
        INavigationNode<?> targetNode = this.findNode(this.getRootNode(sourceNode), targetId);
        if (targetNode == null) {
            INavigationAssembler assembler;
            if (LOGGER.isLoggable(4)) {
                LOGGER.log(4, "createNode: " + targetId);
            }
            if ((assembler = this.getNavigationAssembler(targetId, argument)) != null) {
                NavigationNodeId parentTypeId = this.getParentTypeId(argument, assembler);
                INavigationNode<?> parentNode = this.findNode(this.provideNodeHook(sourceNode, parentTypeId, null), parentTypeId);
                this.prepareNavigationAssembler(targetId, assembler, parentNode);
                INavigationNode<Object>[] targetNodes = argument != null && argument.isCreateNodesAsync() || this.shouldRunAsync(assembler) ? (INavigationNode[])UIExecutor.executeLively((Callable)new Callable<INavigationNode<?>[]>(){

                    @Override
                    public INavigationNode<?>[] call() throws Exception {
                        return assembler.buildNode(targetId, argument);
                    }
                }) : assembler.buildNode(targetId, argument);
                if (targetNodes != null && targetNodes.length > 0) {
                    this.prepareNodesAfterBuild(targetNodes, argument, parentNode, assembler, targetId, sourceNode);
                    targetNode = targetNodes[0];
                }
            } else if (this.getRootNode(sourceNode).isActivated()) {
                throw new ExtensionPointFailure("No assembler found for ID=" + targetId.getTypeId());
            }
        } else {
            this.prepareExistingNode(sourceNode, targetNode, argument);
        }
        if (argument != null && argument.isPrepareAll()) {
            this.prepareAll(targetNode);
        }
        return targetNode;
    }

    private boolean shouldRunAsync(INavigationAssembler assembler) {
        return assembler.getClass().isAnnotationPresent(RunAsync.class);
    }

    protected void prepareNodesAfterBuild(INavigationNode<?>[] targetNodes, NavigationArgument argument, INavigationNode<?> parentNode, INavigationAssembler assembler, NavigationNodeId targetId, INavigationNode<?> sourceNode) {
        NodePositioner nodePositioner = argument != null ? argument.getNodePositioner() : NodePositioner.ADD_END;
        INavigationNode<?>[] iNavigationNodeArray = targetNodes;
        int n = targetNodes.length;
        int n2 = 0;
        while (n2 < n) {
            INavigationNode<?> node = iNavigationNodeArray[n2];
            this.prepareNodeAfterBuild(node, argument, parentNode, assembler, targetId, nodePositioner);
            ++n2;
        }
    }

    protected void prepareNodeAfterBuild(INavigationNode<?> node, NavigationArgument argument, INavigationNode<?> parentNode, INavigationAssembler assembler, NavigationNodeId targetId, NodePositioner nodePositioner) {
        this.storeNavigationArgument(node, argument);
        nodePositioner.addChildToParent(parentNode, node);
        if (node.getNodeId() == null && assembler.getId().equals(targetId.getTypeId())) {
            node.setNodeId(targetId);
        }
    }

    protected void prepareExistingNode(INavigationNode<?> sourceNode, INavigationNode<?> targetNode, NavigationArgument argument) {
        this.storeNavigationArgument(targetNode, argument);
    }

    private void storeNavigationArgument(INavigationNode<?> targetNode, NavigationArgument argument) {
        if (argument != null) {
            targetNode.setContext("riena.navigation.argument", argument);
        }
    }

    public void register(INavigationAssembly2Extension assembly) {
        INavigationAssembler assembler;
        String assemblyId = assembly.getId();
        if (assemblyId == null) {
            if (random == null) {
                try {
                    random = SecureRandom.getInstance("SHA1PRNG");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    random = new Random(System.currentTimeMillis());
                }
            }
            assemblyId = "Riena.random.assemblyid." + Long.valueOf(random.nextLong()).toString();
            LOGGER.log(4, "Assembly has no id. Generated a random '" + assemblyId + "'. For Assembler=" + assembly.getNavigationAssembler());
        }
        if ((assembler = assembly.createNavigationAssembler()) == null) {
            assembler = this.createDefaultAssembler();
        }
        assembler.setId(assemblyId);
        assembler.setParentNodeId(assembly.getParentNodeId());
        assembler.setStartOrder(this.getStartOrder(assembly));
        assembler.setAssembly(assembly);
        this.registerNavigationAssembler(assemblyId, assembler);
    }

    private int getStartOrder(ICommonNavigationAssemblyExtension assembly) {
        try {
            INavigationAssembly2Extension assembly2 = (INavigationAssembly2Extension)assembly;
            return assembly2.getStartOrder();
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    protected INavigationNode<?> getRootNode(INavigationNode<?> node) {
        if (node.getParent() == null) {
            return node;
        }
        return this.getRootNode(node.getParent());
    }

    protected INavigationNode<?> findNode(INavigationNode<?> node, NavigationNodeId targetId) {
        if (targetId == null) {
            return null;
        }
        if (targetId.equals(node.getNodeId())) {
            return node;
        }
        for (INavigationNode child : node.getChildren()) {
            INavigationNode<?> foundNode = this.findNode(child, targetId);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public INavigationAssembler getNavigationAssembler(NavigationNodeId nodeId, NavigationArgument argument) {
        if (nodeId != null && nodeId.getTypeId() != null) {
            for (INavigationAssembler probe : this.getNavigationAssemblers()) {
                if (!probe.acceptsToBuildNode(nodeId, argument)) continue;
                return probe;
            }
        }
        return null;
    }

    private NavigationNodeId getParentTypeId(NavigationArgument argument, INavigationAssembler assembler) {
        if (argument != null && argument.getParentNodeId() != null) {
            return argument.getParentNodeId();
        }
        String parentTypeId = assembler.getParentNodeId();
        if (StringUtils.isEmpty((CharSequence)parentTypeId)) {
            String id = assembler.getId();
            throw new ExtensionPointFailure("parentTypeId cannot be null or blank for assembly ID=" + id);
        }
        return new NavigationNodeId(parentTypeId);
    }

    private void prepareAll(INavigationNode<?> node) {
        node.prepare();
        for (INavigationNode child : node.getChildren()) {
            this.prepareAll(child);
        }
    }

    @Override
    public void cleanUp() {
        this.assemblyId2AssemblerCache.clear();
    }

    @Override
    public INavigationAssembler getNavigationAssembler(String assemblyId) {
        return this.assemblyId2AssemblerCache.get(assemblyId);
    }

    public Collection<INavigationAssembler> getNavigationAssemblers() {
        return this.assemblyId2AssemblerCache.values();
    }

    public void registerNavigationAssembler(String id, INavigationAssembler assembler) {
        INavigationAssembler oldAssembler = this.assemblyId2AssemblerCache.put(id, assembler);
        if (oldAssembler != null) {
            String msg = String.format("There are two assembly extension definitions for '%s'.", id);
            IllegalStateException runtimeExc = new IllegalStateException(msg);
            LOGGER.log(1, msg, (Throwable)runtimeExc);
            throw runtimeExc;
        }
    }

    protected void prepareNavigationAssembler(NavigationNodeId targetId, INavigationAssembler assembler, INavigationNode<?> parentNode) {
        if (assembler instanceof IGenericNavigationAssembler) {
            ((IGenericNavigationAssembler)assembler).setAssemblerProvider(this);
        }
    }

    protected INavigationAssembler createDefaultAssembler() {
        return new GenericNavigationAssembler();
    }
}

