/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.util.Trace;
import org.eclipse.riena.internal.navigation.Activator;
import org.eclipse.riena.navigation.IJumpTargetListener;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationContext;
import org.eclipse.riena.navigation.INavigationHistoryListener;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.INavigationNodeProvider;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ExtensionPointFailure;
import org.eclipse.riena.navigation.model.JumpContext;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.NavigationHistoryEvent;
import org.eclipse.riena.navigation.model.NavigationModelFailure;
import org.eclipse.riena.navigation.model.NavigationNodeProvider;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationProcessor
implements INavigationProcessor {
    private List<ISubModuleNode> collNodes;
    private final Stack<INavigationNode<?>> histBack = new Stack();
    private final Stack<INavigationNode<?>> histForward = new Stack();
    private final Map<INavigationNode<?>, Stack<JumpContext>> jumpTargets = new HashMap();
    private final Map<INavigationNode<?>, List<IJumpTargetListener>> jumpTargetListeners = new HashMap();
    private final Map<INavigationNode<?>, INavigationNode<?>> navigationMap = new HashMap();
    private final List<INavigationHistoryListener> navigationListener = new Vector<INavigationHistoryListener>();
    private static final int MAX_HISTORY_LENGTH = 40;
    private static final boolean DEBUG_NAVIGATION_PROCESSOR = Trace.isOn(NavigationProcessor.class, (String)"debug");
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), NavigationProcessor.class);

    @Override
    public void activate(INavigationNode<?> toActivate) {
        if (toActivate != null) {
            IModuleNode moduleNode = toActivate.getParentOfType(IModuleNode.class);
            this.collNodes = this.collectCollapsedNodes(moduleNode);
            if (toActivate.isActivated()) {
                if (DEBUG_NAVIGATION_PROCESSOR) {
                    LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId() + "but is already activated --> NOP");
                }
                Nop.reason((String)"see comment below.");
            } else {
                if (DEBUG_NAVIGATION_PROCESSOR) {
                    LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId());
                }
                if (!toActivate.isVisible() || !toActivate.isEnabled()) {
                    if (DEBUG_NAVIGATION_PROCESSOR) {
                        LOGGER.log(4, "NaviProc: - activate triggered for Node " + toActivate.getNodeId() + "but is not visible or not enabled --> NOP");
                    }
                    return;
                }
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnActivation(toActivate);
                if (toActivateList.isEmpty()) {
                    return;
                }
                List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnActivation(toActivate);
                NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                if (this.allowsDeactivate(navigationContext)) {
                    if (this.allowsActivate(navigationContext)) {
                        this.deactivate(navigationContext);
                        this.activate(navigationContext);
                    } else {
                        INavigationNode<?> currentActive = this.getActiveChild(toActivate.getParent());
                        toActivateList.clear();
                        toActivateList.add(currentActive);
                        toDeactivateList.clear();
                        navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                        this.activate(navigationContext);
                        currentActive.onAfterActivate(navigationContext);
                    }
                }
            }
        }
    }

    @Override
    public void markNodesToCollapse(INavigationNode<?> toActivate) {
        if (toActivate.getContext("fromUI") == null) {
            if (this.collNodes != null) {
                for (ISubModuleNode node : this.collNodes) {
                    if (!node.isExpanded()) continue;
                    node.setCloseSubTree(true);
                }
            }
        } else {
            toActivate.removeContext("fromUI");
        }
    }

    private boolean isJumpSource(ISubModuleNode node) {
        for (Map.Entry<INavigationNode<?>, Stack<JumpContext>> entry : this.jumpTargets.entrySet()) {
            Stack<JumpContext> value = entry.getValue();
            if (value.isEmpty() || !value.peek().getSource().equals(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeOrChildJumpSource(ISubModuleNode node) {
        List children = node.getChildren();
        if (this.isJumpSource(node)) {
            this.exemptNodeFromCollapsing(node);
            return true;
        }
        for (ISubModuleNode child : children) {
            if (!this.isJumpSource(child)) continue;
            node.setCloseSubTree(false);
            this.exemptNodeFromCollapsing(child);
            return true;
        }
        return false;
    }

    private void exemptNodeFromCollapsing(ISubModuleNode node) {
        node.setCloseSubTree(false);
        ISubModuleNode parent = node.getParentOfType(ISubModuleNode.class);
        while (parent != null) {
            if (this.collNodes.contains(parent)) {
                parent.setCloseSubTree(false);
            }
            parent = parent.getParentOfType(ISubModuleNode.class);
        }
    }

    private List<ISubModuleNode> collectCollapsedNodes(INavigationNode<?> node) {
        LinkedList<ISubModuleNode> collapsedNodes = new LinkedList<ISubModuleNode>();
        List<Object> children = new LinkedList();
        if (node instanceof IModuleNode) {
            children = ((IModuleNode)node).getChildren();
        } else if (node instanceof ISubModuleNode) {
            children = ((ISubModuleNode)node).getChildren();
        }
        for (ISubModuleNode child : children) {
            if (!(collapsedNodes.contains(child) || child.isExpanded() && !child.isCloseSubTree() || this.isNodeOrChildJumpSource(child))) {
                collapsedNodes.add(child);
            }
            if (child.isLeaf()) continue;
            collapsedNodes.addAll(this.collectCollapsedNodes(child));
        }
        return collapsedNodes;
    }

    @Override
    public void prepare(INavigationNode<?> toPrepare) {
        LinkedList toPreparedList = new LinkedList();
        toPreparedList.add(toPrepare);
        NavigationContext navigationContext = new NavigationContext(toPreparedList, null, null);
        toPrepare.prepare(navigationContext);
    }

    private void buildHistory(INavigationNode<?> toActivate) {
        if (!(toActivate instanceof ISubModuleNode) || toActivate.isDisposed()) {
            return;
        }
        if (this.histBack.isEmpty() || !this.histBack.peek().equals(toActivate)) {
            this.histBack.push(toActivate);
            if (this.histBack.size() > 40) {
                this.histBack.remove(this.histBack.firstElement());
            }
            this.fireBackHistoryChangedEvent();
        }
        if (!this.histForward.isEmpty() && this.histForward.peek().equals(toActivate)) {
            this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
        }
    }

    @Override
    public void dispose(INavigationNode<?> toDispose) {
        INavigationNode<?> nodeToDispose = this.getNodeToDispose(toDispose);
        if (nodeToDispose != null && !nodeToDispose.isDisposed()) {
            INavigationNode.State nodeStartState = nodeToDispose.getState();
            this.handleJumpsOnDispose(nodeToDispose);
            List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToDispose);
            List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnDispose(nodeToDispose);
            NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
            if (this.allowsDeactivate(navigationContext) && this.allowsDispose(navigationContext) && this.allowsActivate(navigationContext)) {
                if (nodeStartState != nodeToDispose.getState()) {
                    String msg = String.format("State of node '%s' changed unexpected!", toDispose);
                    throw new NavigationModelFailure(msg);
                }
                this.deactivate(navigationContext);
                this.dispose(navigationContext);
                this.activate(navigationContext);
            }
            this.cleanupHistory(nodeToDispose);
            this.cleanupJumpTargetListeners(nodeToDispose);
        }
    }

    @Override
    public void addMarker(INavigationNode<?> node, IMarker marker) {
        if (node != null) {
            INavigationNode<?> nodeToHide;
            if (node.isActivated() && (marker instanceof DisabledMarker || marker instanceof HiddenMarker) && (nodeToHide = this.getNodeToDispose(node)) != null) {
                List<INavigationNode<?>> toDeactivateList = this.getNodesToDeactivateOnDispose(nodeToHide);
                List<INavigationNode<?>> toActivateList = this.getNodesToActivateOnDispose(nodeToHide);
                NavigationContext navigationContext = new NavigationContext(null, toActivateList, toDeactivateList);
                if (this.allowsDeactivate(navigationContext) && this.allowsActivate(navigationContext)) {
                    this.deactivate(navigationContext);
                    this.activate(navigationContext);
                } else {
                    return;
                }
            }
            if (marker instanceof DisabledMarker || marker instanceof HiddenMarker) {
                node.setSelected(false);
            }
            LinkedList toMarkList = new LinkedList();
            toMarkList.add(node);
            NavigationContext navigationContext = new NavigationContext(null, toMarkList, null);
            this.addMarker(navigationContext, marker);
        }
    }

    private void addMarker(INavigationContext context, IMarker marker) {
        for (INavigationNode<?> node : context.getToActivate()) {
            node.addMarker(context, marker);
        }
    }

    private void cleanupHistory(INavigationNode<?> toDispose) {
        while (this.histBack.contains(toDispose)) {
            this.histBack.remove(toDispose);
        }
        this.fireBackHistoryChangedEvent();
        boolean fhc = false;
        while (this.histForward.contains(toDispose)) {
            this.histForward.remove(toDispose);
            fhc = true;
        }
        if (fhc) {
            this.fireForewardHistoryChangedEvent();
        }
        if (this.navigationMap.containsKey(toDispose)) {
            this.navigationMap.remove(toDispose);
        }
    }

    @Override
    public INavigationNode<?> create(INavigationNode<?> sourceNode, NavigationNodeId targetId) {
        return this.provideNode(sourceNode, targetId, null);
    }

    @Override
    public INavigationNode<?> create(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        return this.provideNode(sourceNode, targetId, argument);
    }

    @Override
    public void move(INavigationNode<?> sourceNode, NavigationNodeId targetId) {
        Assert.isTrue((boolean)ModuleNode.class.isAssignableFrom(sourceNode.getClass()));
        ModuleNode sourceModuleNode = (ModuleNode)ModuleNode.class.cast(sourceNode);
        INavigationNode<?> targetNode = this.create(sourceNode, targetId);
        Assert.isTrue((boolean)ModuleGroupNode.class.isAssignableFrom(targetNode.getClass()));
        ModuleGroupNode targetModuleGroup = (ModuleGroupNode)ModuleGroupNode.class.cast(targetNode);
        ModuleGroupNode oldParentModuleGroup = (ModuleGroupNode)ModuleGroupNode.class.cast(sourceModuleNode.getParent());
        if (targetModuleGroup.equals(oldParentModuleGroup)) {
            return;
        }
        boolean isActivated = sourceModuleNode.isActivated();
        boolean isBlocked = sourceModuleNode.isBlocked();
        boolean isEnabled = sourceModuleNode.isEnabled();
        boolean isVisible = sourceModuleNode.isVisible();
        sourceModuleNode.dispose(null);
        sourceModuleNode.deactivate(null);
        oldParentModuleGroup.removeChild(sourceModuleNode);
        targetModuleGroup.addChild(sourceModuleNode);
        for (ISubModuleNode child : sourceModuleNode.getChildren()) {
            child.setParent(sourceModuleNode);
        }
        sourceModuleNode.setBlocked(isBlocked || targetModuleGroup.isBlocked());
        sourceModuleNode.setEnabled(isEnabled && targetModuleGroup.isEnabled());
        sourceModuleNode.setVisible(isVisible && targetModuleGroup.isVisible());
        if (isActivated) {
            sourceModuleNode.activate();
        }
        if (oldParentModuleGroup.getChildren().size() == 0) {
            oldParentModuleGroup.dispose();
        } else {
            ((IModuleNode)oldParentModuleGroup.getChild(0)).setSelected(true);
        }
    }

    @Override
    public INavigationNode<?> navigate(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation) {
        return this.navigateSync(sourceNode, targetId, navigation, NavigationType.DEFAULT);
    }

    private INavigationNode<?> navigateSync(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument navigation, NavigationType navigationType) {
        INavigationNode<?> targetNode = null;
        try {
            targetNode = this.provideNode(sourceNode, targetId, navigation);
        }
        catch (NavigationModelFailure failure) {
            LOGGER.log(1, failure.getMessage());
        }
        if (targetNode == null) {
            return null;
        }
        INavigationNode<?> activateNode = targetNode.findNode(targetId);
        INavigationNode<?> node = activateNode;
        if (node == null) {
            node = targetNode;
        }
        this.navigationMap.put(node, sourceNode);
        if (NavigationType.JUMP == navigationType) {
            this.handleJump(sourceNode, node);
        }
        node.activate();
        try {
            this.setFocusOnRidget(node, navigation);
        }
        catch (NavigationModelFailure failure) {
            LOGGER.log(1, failure.getMessage());
        }
        return node;
    }

    private void handleJump(final INavigationNode<?> sourceNode, final INavigationNode<?> node) {
        this.runObserved(sourceNode, new Runnable(){

            public void run() {
                NavigationProcessor.this.registerJump(sourceNode, node);
            }
        });
    }

    private INavigationNode<?> getRootNode(INavigationNode<?> node) {
        INavigationNode<?> topNode = node;
        while (topNode.getParent() != null) {
            topNode = topNode.getParent();
        }
        return topNode;
    }

    private Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> saveJumpState(INavigationNode<?> node) {
        INavigationNode<?> topNode = this.getRootNode(node);
        HashMap savedJumpState = new HashMap();
        this.saveJumpState(topNode, savedJumpState);
        return savedJumpState;
    }

    private void saveJumpState(INavigationNode<?> root, Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState) {
        savedJumpState.put(root, this.isJumpTarget(root) ? IJumpTargetListener.JumpTargetState.ENABLED : IJumpTargetListener.JumpTargetState.DISABLED);
        for (INavigationNode child : root.getChildren()) {
            this.saveJumpState(child, savedJumpState);
        }
    }

    private void notifyJumpStateChanged(INavigationNode<?> node, Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> oldJumpState) {
        Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState = this.saveJumpState(node);
        for (Map.Entry<INavigationNode<?>, IJumpTargetListener.JumpTargetState> entry : savedJumpState.entrySet()) {
            if (oldJumpState.get(entry.getKey()) == entry.getValue()) continue;
            this.notifyJumpStateChanged(entry.getKey(), entry.getValue());
        }
    }

    private void notifyJumpStateChanged(INavigationNode<?> node, IJumpTargetListener.JumpTargetState jumpTargetState) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            return;
        }
        for (IJumpTargetListener listener : listeners) {
            listener.jumpTargetStateChanged(node, jumpTargetState);
        }
    }

    private void registerJump(INavigationNode<?> source, INavigationNode<?> target) {
        Stack<JumpContext> sourceStack = this.jumpTargets.get(target);
        if (sourceStack == null) {
            sourceStack = new Stack();
            this.jumpTargets.put(target, sourceStack);
        }
        if (sourceStack.size() == 0 || !sourceStack.peek().getSource().equals(source)) {
            sourceStack.push(new JumpContext(source, target));
        }
    }

    private void handleJumpsOnDispose(final INavigationNode<?> node) {
        this.runObserved(node, new Runnable(){

            public void run() {
                NavigationProcessor.this.unregisterNodeJumps(node);
            }
        });
    }

    private void unregisterNodeJumps(INavigationNode<?> node) {
        this.jumpTargets.remove(node);
        Iterator<Map.Entry<INavigationNode<?>, Stack<JumpContext>>> it = this.jumpTargets.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<INavigationNode<?>, Stack<JumpContext>> entry = it.next();
            Stack<JumpContext> entryStack = entry.getValue();
            JumpContext ctx = null;
            for (JumpContext ictx : entryStack) {
                if (!ictx.getSource().equals(node)) continue;
                ctx = ictx;
            }
            entryStack.remove(ctx);
            if (!entryStack.isEmpty()) continue;
            it.remove();
        }
        for (INavigationNode child : node.getChildren()) {
            this.unregisterNodeJumps(child);
        }
    }

    @Override
    public void jump(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        this.navigateSync(sourceNode, targetId, argument, NavigationType.JUMP);
    }

    @Override
    public void jumpBack(final INavigationNode<?> node) {
        this.runObserved(node, new Runnable(){

            public void run() {
                NavigationProcessor.this.jumpBackInternal(node);
            }
        });
    }

    private void jumpBackInternal(INavigationNode<?> node) {
        INavigationNode<?> lastJumpedNode = this.getLastJump(node);
        Stack<JumpContext> sourceStack = this.jumpTargets.get(lastJumpedNode);
        if (sourceStack == null) {
            return;
        }
        if (!sourceStack.isEmpty()) {
            INavigationNode<?> backTarget = sourceStack.pop().getSource();
            this.setCloseSubTreeOnJumpBack(backTarget);
            if (sourceStack.isEmpty()) {
                this.jumpTargets.remove(lastJumpedNode);
            }
            backTarget.activate();
        }
    }

    private void runObserved(INavigationNode<?> node, Runnable runnable) {
        Map<INavigationNode<?>, IJumpTargetListener.JumpTargetState> savedJumpState = this.saveJumpState(node);
        runnable.run();
        this.notifyJumpStateChanged(node, savedJumpState);
    }

    private INavigationNode<?> getLastJump(INavigationNode<?> node) {
        ModuleGroupNode moduleGroupNode;
        ModuleGroupNode moduleGroupNode2 = moduleGroupNode = node instanceof ModuleGroupNode ? node : node.getParentOfType(ModuleGroupNode.class);
        if (moduleGroupNode == null) {
            return node;
        }
        LinkedList nodes = new LinkedList();
        this.collectNodes(moduleGroupNode, nodes);
        ArrayList<JumpContext> latestJumpSources = new ArrayList<JumpContext>();
        for (INavigationNode iNavigationNode : nodes) {
            if (!this.jumpTargets.containsKey(iNavigationNode)) continue;
            latestJumpSources.add(this.jumpTargets.get(iNavigationNode).peek());
        }
        if (latestJumpSources.size() > 0) {
            Collections.sort(latestJumpSources);
            return ((JumpContext)latestJumpSources.get(latestJumpSources.size() - 1)).getTarget();
        }
        return null;
    }

    private void collectNodes(INavigationNode<?> root, List<INavigationNode<?>> nodes) {
        nodes.add(root);
        for (INavigationNode child : root.getChildren()) {
            this.collectNodes(child, nodes);
        }
    }

    private void setCloseSubTreeOnJumpBack(INavigationNode<?> backTarget) {
        if (backTarget.isLeaf() && backTarget.getParentOfType(ISubModuleNode.class) != null) {
            backTarget.getParentOfType(ISubModuleNode.class).setCloseSubTree(true);
        } else {
            ((ISubModuleNode)backTarget).setCloseSubTree(true);
        }
    }

    @Override
    public boolean isJumpTarget(INavigationNode<?> node) {
        ModuleGroupNode moduleGroupNode = node.getParentOfType(ModuleGroupNode.class);
        INavigationNode<?> targetNode = null;
        targetNode = moduleGroupNode == null ? node : this.getLastJump(moduleGroupNode);
        Stack<JumpContext> sourceStack = this.jumpTargets.get(targetNode);
        return sourceStack != null && sourceStack.size() > 0;
    }

    @Override
    public void addJumpTargetListener(INavigationNode<?> node, IJumpTargetListener listener) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            listeners = new LinkedList<IJumpTargetListener>();
            this.jumpTargetListeners.put(node, listeners);
        }
        listeners.add(listener);
    }

    @Override
    public void removeJumpTargetListener(INavigationNode<?> node, IJumpTargetListener listener) {
        List<IJumpTargetListener> listeners = this.jumpTargetListeners.get(node);
        if (listeners == null) {
            return;
        }
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.jumpTargetListeners.remove(node);
        }
    }

    private void cleanupJumpTargetListeners(INavigationNode<?> node) {
        this.jumpTargetListeners.remove(node);
        for (INavigationNode child : node.getChildren()) {
            this.cleanupJumpTargetListeners(child);
        }
    }

    private void setFocusOnRidget(INavigationNode<?> activateNode, NavigationArgument navigation) {
        if (navigation != null && navigation.getRidgetId() != null) {
            IRidgetContainer ridgetContainer = activateNode.getNavigationNodeController().getTypecastedAdapter(IRidgetContainer.class);
            IRidget ridget = ridgetContainer.getRidget(navigation.getRidgetId());
            if (ridget != null) {
                ridget.requestFocus();
            } else {
                throw new NavigationModelFailure(String.format("Ridget not found '%s'", navigation.getRidgetId()));
            }
        }
    }

    private INavigationNode<?> provideNode(INavigationNode<?> sourceNode, NavigationNodeId targetId, NavigationArgument argument) {
        try {
            return this.getNavigationNodeProvider().provideNode(sourceNode, targetId, argument);
        }
        catch (ExtensionPointFailure failure) {
            throw new NavigationModelFailure(String.format("Node not found '%s'", targetId), (Throwable)((Object)failure));
        }
    }

    protected INavigationNodeProvider getNavigationNodeProvider() {
        return NavigationNodeProvider.getInstance();
    }

    private INavigationNode<?> getNodeToDispose(INavigationNode<?> toDispose) {
        int ind;
        INavigationNode<ISubModuleNode> parent;
        IModuleNode moduleNode = toDispose.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null && (parent = moduleNode.getParent()) != null && (ind = parent.getIndexOfChild(moduleNode)) == 0) {
            return parent;
        }
        return toDispose;
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnDispose(INavigationNode<?> toDispose) {
        LinkedList allToDispose = new LinkedList();
        this.addAllChildren(allToDispose, toDispose);
        if (this.isOnlySubModule(toDispose)) {
            allToDispose.add(toDispose.getParent());
        }
        return allToDispose;
    }

    private boolean isOnlySubModule(INavigationNode<?> node) {
        return node.getParent() instanceof IModuleNode && node.getParent().getChildren().size() == 1;
    }

    private void addAllChildren(List<INavigationNode<?>> allToDispose, INavigationNode<?> toDispose) {
        for (Object nextChild : toDispose.getChildren()) {
            this.addAllChildren(allToDispose, (INavigationNode)nextChild);
        }
        allToDispose.add(toDispose);
    }

    private List<INavigationNode<?>> getNodesToActivateOnDispose(INavigationNode<?> toDispose) {
        if (toDispose.isActivated()) {
            INavigationNode<?> parentOfToDispose = this.getParentToActivate(toDispose);
            INavigationNode<?> brotherToActivate = null;
            if (parentOfToDispose != null) {
                List<?> childrenOfParentOfToDispose = parentOfToDispose.getChildren();
                List<INavigationNode<?>> activatableNode = this.getActivatableNodes(childrenOfParentOfToDispose);
                if (childrenOfParentOfToDispose.size() > 1) {
                    for (INavigationNode<?> nextChild : activatableNode) {
                        if (nextChild.equals(toDispose)) continue;
                        brotherToActivate = nextChild;
                        break;
                    }
                }
            }
            if (brotherToActivate != null) {
                return this.getNodesToActivateOnActivation(brotherToActivate);
            }
        }
        return new LinkedList();
    }

    private INavigationNode<?> getParentToActivate(INavigationNode<?> node) {
        if (this.isOnlySubModule(node)) {
            if (node.getParentOfType(IModuleGroupNode.class).getChildren().size() == 1) {
                return node.getParentOfType(ISubApplicationNode.class);
            }
            return node.getParentOfType(IModuleGroupNode.class);
        }
        return node.getParent();
    }

    private List<INavigationNode<?>> getActivatableNodes(List<?> nodes) {
        LinkedList activatableNodes = new LinkedList();
        for (Object node : nodes) {
            INavigationNode naviNode;
            if (!(node instanceof INavigationNode) || !(naviNode = (INavigationNode)node).isVisible() || !naviNode.isEnabled()) continue;
            activatableNodes.add(naviNode);
        }
        return activatableNodes;
    }

    private List<INavigationNode<?>> getNodesToActivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToActivate = new LinkedList();
        this.addParentsToActivate(nodesToActivate, toActivate);
        this.addChildrenToActivate(nodesToActivate, toActivate);
        return nodesToActivate;
    }

    private void addParentsToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> parent = this.getActivationParent(toActivate);
        if (parent != null) {
            if (parent.isActivated()) {
                this.addSelectableNode(nodesToActivate, toActivate);
            } else {
                this.addParentsToActivate(nodesToActivate, parent);
                this.addSelectableNode(nodesToActivate, toActivate);
            }
        } else {
            nodesToActivate.add(toActivate);
        }
    }

    private void addSelectableNode(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        if (toActivate instanceof ISubModuleNode && !((ISubModuleNode)toActivate).isSelectable()) {
            Nop.reason((String)"do not add; not selectable");
        } else {
            nodesToActivate.add(toActivate);
        }
    }

    private INavigationNode<?> getActivationParent(INavigationNode<?> child) {
        ISubModuleNode subModuleNode = child.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            INavigationNode<?> parent = child.getParent();
            while (parent != null) {
                if (parent.getTypecastedAdapter(IModuleNode.class) != null) {
                    return parent;
                }
                parent = parent.getParent();
            }
        } else {
            return child.getParent();
        }
        return null;
    }

    private void addChildrenToActivate(List<INavigationNode<?>> nodesToActivate, INavigationNode<?> toActivate) {
        INavigationNode<?> childToActivate = this.getChildToActivate(toActivate);
        if (childToActivate != null) {
            nodesToActivate.add(childToActivate);
            this.addChildrenToActivate(nodesToActivate, childToActivate);
        }
    }

    private List<INavigationNode<?>> getNodesToDeactivateOnActivation(INavigationNode<?> toActivate) {
        LinkedList nodesToDeactivate = new LinkedList();
        INavigationNode<?> activeParent = this.getNextActiveParent(toActivate);
        if (activeParent != null) {
            INavigationNode<?> activeChild = this.getActiveChild(activeParent);
            if (activeChild != null) {
                this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            }
        } else {
            this.addChildrenToDeactivate(nodesToDeactivate, this.getTopParent(toActivate));
        }
        return nodesToDeactivate;
    }

    private void addChildrenToDeactivate(List<INavigationNode<?>> nodesToDeactivate, INavigationNode<?> toAdd) {
        INavigationNode<?> activeChild = this.getActiveChild(toAdd);
        if (activeChild != null) {
            this.addChildrenToDeactivate(nodesToDeactivate, activeChild);
            nodesToDeactivate.add(toAdd);
        } else {
            nodesToDeactivate.add(toAdd);
        }
    }

    private INavigationNode<?> getNextActiveParent(INavigationNode<?> node) {
        ISubModuleNode subModuleNode = node.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return this.getNextActiveParent(subModuleNode.getParent());
        }
        if (node.isActivated()) {
            return node;
        }
        if (node.getParent() != null) {
            return this.getNextActiveParent(node.getParent());
        }
        return null;
    }

    private INavigationNode<?> getTopParent(INavigationNode<?> node) {
        if (node.getParent() != null) {
            return this.getTopParent(node.getParent());
        }
        return node;
    }

    private boolean allowsActivate(INavigationContext context) {
        for (INavigationNode<?> nextToActivate : context.getToActivate()) {
            if (nextToActivate.allowsActivate(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDispose(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDispose(context)) continue;
            return false;
        }
        return true;
    }

    private boolean allowsDeactivate(INavigationContext context) {
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (nextToDeactivate.allowsDeactivate(context)) continue;
            return false;
        }
        return true;
    }

    private void activate(INavigationContext context) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull(context.getToActivate());
        List<INavigationNode<?>> nextNodesToActivate = context.getToActivate();
        if (nextNodesToActivate.isEmpty()) {
            LOGGER.log(4, "NaviProc: - There is no node to activate!");
        }
        for (INavigationNode<?> nextToActivate : nextNodesToActivate) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - beforeActivate: " + nextToActivate.getNodeId());
            }
            nextToActivate.onBeforeActivate(context);
        }
        for (INavigationNode<?> nextToActivate : nextNodesToActivate) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - activate: " + nextToActivate.getNodeId());
            }
            nextToActivate.activate(context);
            this.setAsSelectedChild(nextToActivate);
        }
        for (INavigationNode<?> nextToActivate : this.copyReverse(nextNodesToActivate)) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - onAfterActivate: " + nextToActivate.getNodeId());
            }
            nextToActivate.onAfterActivate(context);
        }
    }

    private void deactivate(INavigationContext context) {
        ArrayList previouslyActivatedNodes = new ArrayList();
        for (INavigationNode<?> nextToDeactivate : this.copyReverse(context.getToDeactivate())) {
            if (!nextToDeactivate.isActivated()) continue;
            previouslyActivatedNodes.add(nextToDeactivate);
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - beforeDeactivate: " + nextToDeactivate.getNodeId());
            }
            nextToDeactivate.onBeforeDeactivate(context);
        }
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(nextToDeactivate)) continue;
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - deactivate: " + nextToDeactivate.getNodeId());
            }
            nextToDeactivate.deactivate(context);
        }
        for (INavigationNode<?> nextToDeactivate : context.getToDeactivate()) {
            if (!previouslyActivatedNodes.contains(nextToDeactivate)) continue;
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - onAfterDeactivate: " + nextToDeactivate.getNodeId());
            }
            nextToDeactivate.onAfterDeactivate(context);
        }
    }

    private void dispose(INavigationContext context) {
        for (INavigationNode<?> nextToDispose : this.copyReverse(context.getToDeactivate())) {
            nextToDispose.onBeforeDispose(context);
        }
        for (INavigationNode<?> nextToDispose : context.getToDeactivate()) {
            if (DEBUG_NAVIGATION_PROCESSOR) {
                LOGGER.log(4, "NaviProc: - dispos: " + nextToDispose.getNodeId());
            }
            nextToDispose.dispose(context);
            INavigationNode<?> parent = nextToDispose.getParent();
            if (parent == null) continue;
            parent.removeChild(nextToDispose);
        }
        for (INavigationNode<?> nextToDispose : context.getToDeactivate()) {
            nextToDispose.onAfterDispose(context);
            this.cleanupHistory(nextToDispose);
        }
    }

    private INavigationNode<?> getChildToActivate(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            if (!subModuleNode.isSelectable() && !subModuleNode.getChildren().isEmpty()) {
                return this.findSelectableChildNode(subModuleNode);
            }
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            if (nextChild != null) {
                ISubModuleNode nextTmp;
                while ((nextTmp = this.getSelectedChild(nextChild)) != null) {
                    nextChild = nextTmp;
                }
                return nextChild;
            }
            if (moduleNode.getChildren().size() > 0) {
                ISubModuleNode subModule = null;
                Iterator subIter = moduleNode.getChildren().iterator();
                while (subModule == null && subIter.hasNext()) {
                    subModule = this.findSelectableChildNode((ISubModuleNode)subIter.next());
                }
                return subModule;
            }
            return null;
        }
        INavigationNode<?> nextSelectedChild = this.getSelectedChild(pNode);
        if (nextSelectedChild != null) {
            return nextSelectedChild;
        }
        for (INavigationNode next : pNode.getChildren()) {
            if (!next.isVisible() || !next.isEnabled()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode findSelectableChildNode(ISubModuleNode startNode) {
        if (!startNode.isVisible()) {
            return null;
        }
        if (startNode.isSelectable()) {
            return startNode;
        }
        startNode.setExpanded(true);
        for (ISubModuleNode child : startNode.getChildren()) {
            ISubModuleNode found = this.findSelectableChildNode(child);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private INavigationNode<?> getActiveChild(INavigationNode<?> pNode) {
        INavigationNode<?> nextSelectedChild;
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            return null;
        }
        IModuleNode moduleNode = pNode.getTypecastedAdapter(IModuleNode.class);
        if (moduleNode != null) {
            ISubModuleNode nextChild = this.getSelectedChild(moduleNode);
            if (nextChild != null) {
                while (nextChild != null) {
                    if (nextChild.isActivated()) {
                        return nextChild;
                    }
                    if (this.getSelectedChild(nextChild) != null) {
                        nextChild = this.getSelectedChild(nextChild);
                        continue;
                    }
                    return null;
                }
            } else {
                return null;
            }
        }
        if ((nextSelectedChild = this.getSelectedChild(pNode)) != null && nextSelectedChild.isActivated()) {
            return nextSelectedChild;
        }
        return null;
    }

    private void setAsSelectedChild(INavigationNode<?> pNode) {
        ISubModuleNode subModuleNode = pNode.getTypecastedAdapter(ISubModuleNode.class);
        if (subModuleNode != null) {
            ISubModuleNode nextToSet = subModuleNode;
            while (nextToSet != null) {
                if (nextToSet.getParent() == null) continue;
                this.setSelectedChild(nextToSet.getParent(), nextToSet);
                nextToSet = nextToSet.getParent().getTypecastedAdapter(ISubModuleNode.class);
            }
            this.setSelectedChild(subModuleNode, null);
            return;
        }
        if (pNode.getParent() != null) {
            this.setSelectedChild(pNode.getParent(), pNode);
        }
    }

    private void setSelectedChild(INavigationNode<?> parent, INavigationNode<?> child) {
        for (INavigationNode next : parent.getChildren()) {
            if (next.equals(child)) {
                next.setSelected(true);
                if (!next.isActivated()) continue;
                this.buildHistory(next);
                continue;
            }
            next.setSelected(false);
        }
    }

    private INavigationNode<?> getSelectedChild(INavigationNode<?> pNavigationNode) {
        for (INavigationNode next : pNavigationNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(IModuleNode pModuleNode) {
        for (ISubModuleNode next : pModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private ISubModuleNode getSelectedChild(ISubModuleNode pSubModuleNode) {
        for (ISubModuleNode next : pSubModuleNode.getChildren()) {
            if (!next.isSelected()) continue;
            return next;
        }
        return null;
    }

    private List<INavigationNode<?>> copyReverse(List<INavigationNode<?>> list) {
        List<INavigationNode<?>> listReverse = list.subList(0, list.size());
        Collections.reverse(listReverse);
        return listReverse;
    }

    @Override
    public void historyBack() {
        if (this.getHistoryBackSize() > 0) {
            INavigationNode<?> current = this.histBack.pop();
            this.fireBackHistoryChangedEvent();
            this.histForward.push(current);
            if (this.histForward.size() > 40) {
                this.histForward.remove(this.histForward.firstElement());
            }
            this.fireForewardHistoryChangedEvent();
            INavigationNode<?> node = this.histBack.peek();
            if (node != null) {
                this.activate(node);
            }
        }
    }

    private void fireBackHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, Math.max(0, this.histBack.size() - 1)));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.backHistoryChanged(event);
        }
    }

    @Override
    public void historyForward() {
        if (this.getHistoryForwardSize() > 0) {
            INavigationNode<?> current = this.histForward.pop();
            this.fireForewardHistoryChangedEvent();
            if (current != null) {
                this.histBack.push(current);
                if (this.histBack.size() > 40) {
                    this.histBack.remove(this.histBack.firstElement());
                }
                this.activate(current);
                this.fireBackHistoryChangedEvent();
            }
        }
    }

    private void fireForewardHistoryChangedEvent() {
        if (this.navigationListener.size() == 0) {
            return;
        }
        NavigationHistoryEvent event = new NavigationHistoryEvent(this.histForward.subList(0, this.histForward.size()));
        for (INavigationHistoryListener listener : this.navigationListener) {
            listener.forwardHistoryChanged(event);
        }
    }

    @Override
    public int getHistoryBackSize() {
        return this.histBack.size() - 1;
    }

    @Override
    public INavigationNode<?> getSelectedNode() {
        return this.histBack.peek();
    }

    @Override
    public int getHistoryForwardSize() {
        return this.histForward.size();
    }

    @Override
    public void navigateBack(INavigationNode<?> targetNode) {
        INavigationNode<?> sourceNode = null;
        INavigationNode<?> lookupNode = targetNode;
        while (sourceNode == null) {
            sourceNode = this.navigationMap.get(lookupNode);
            if (sourceNode != null || (lookupNode = lookupNode.getParent()) != null) continue;
            return;
        }
        this.navigate(targetNode, sourceNode.getNodeId(), null);
    }

    @Override
    public synchronized void addNavigationHistoryListener(INavigationHistoryListener listener) {
        if (!this.navigationListener.contains(listener)) {
            this.navigationListener.add(listener);
            NavigationHistoryEvent event = new NavigationHistoryEvent(this.histBack.subList(0, this.histBack.size() > 0 ? this.histBack.size() - 1 : 0));
            listener.backHistoryChanged(event);
            event = new NavigationHistoryEvent(this.histForward.subList(0, this.histForward.size()));
            listener.forwardHistoryChanged(event);
        }
    }

    @Override
    public synchronized void removeNavigationHistoryListener(INavigationHistoryListener listener) {
        this.navigationListener.remove(listener);
    }

    @Override
    public List<INavigationNode<?>> getHistory() {
        return Collections.unmodifiableList(this.histBack);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NavigationContext
    implements INavigationContext {
        private static final List<INavigationNode<?>> EMPTY_LIST = new LinkedList();
        private List<INavigationNode<?>> toDeactivate;
        private List<INavigationNode<?>> toActivate;
        private List<INavigationNode<?>> toPrepare;

        public NavigationContext(List<INavigationNode<?>> toPrepare, List<INavigationNode<?>> toActivate, List<INavigationNode<?>> toDeactivate) {
            this.toPrepare = toPrepare;
            this.toActivate = toActivate;
            this.toDeactivate = toDeactivate;
            if (this.toPrepare == null) {
                this.toPrepare = EMPTY_LIST;
            }
            if (this.toActivate == null) {
                this.toActivate = EMPTY_LIST;
            }
            if (this.toDeactivate == null) {
                this.toDeactivate = EMPTY_LIST;
            }
        }

        @Override
        public List<INavigationNode<?>> getToActivate() {
            return this.toActivate;
        }

        @Override
        public List<INavigationNode<?>> getToDeactivate() {
            return this.toDeactivate;
        }

        @Override
        public List<INavigationNode<?>> getToPrepare() {
            return this.toPrepare;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum NavigationType {
        DEFAULT,
        JUMP;

    }
}

