/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.riena.toolbox.internal.previewer.Activator;
import org.eclipse.riena.toolbox.previewer.IPreviewCustomizer;
import org.eclipse.riena.toolbox.previewer.model.ViewPartInfo;
import org.eclipse.riena.toolbox.previewer.ui.WorkbenchUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceClassLoader {
    private static final String EXTENSION_JAVA = ".java";
    private static WorkspaceClassLoader classFinder;
    private static IPreviewCustomizer previewCustomizer;
    private ISelectionService selectionService;

    private WorkspaceClassLoader() {
    }

    public static WorkspaceClassLoader getInstance() {
        if (classFinder == null) {
            classFinder = new WorkspaceClassLoader();
        }
        return classFinder;
    }

    public ICompilationUnit getSelectionFromPackageExplorer() {
        this.selectionService = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
        ITreeSelection selection = (ITreeSelection)this.selectionService.getSelection("org.eclipse.jdt.ui.PackageExplorer");
        Object firstSelection = selection.getFirstElement();
        if (!(firstSelection instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)firstSelection;
    }

    public ViewPartInfo loadClass(ICompilationUnit comp) {
        return this.loadClass(comp, true);
    }

    public ViewPartInfo loadClass(ICompilationUnit comp, boolean notifyHooks) {
        Class<?> viewClass;
        StringBuilder className;
        block13: {
            IPath path = comp.getPath();
            if (path.segmentCount() < 2) {
                return null;
            }
            className = new StringBuilder();
            int i = 2;
            while (i < path.segmentCount()) {
                String segment = path.segment(i);
                if (segment.endsWith(EXTENSION_JAVA)) {
                    segment = segment.replace(EXTENSION_JAVA, "");
                }
                className.append(segment);
                if (i < path.segmentCount() - 1) {
                    className.append(".");
                }
                ++i;
            }
            IPreviewCustomizer contrib = null;
            Class parentClass = ViewPart.class;
            if (notifyHooks) {
                contrib = this.getContributedPreviewCustomizer();
            }
            if (contrib != null && contrib.getParentClass() != null) {
                parentClass = contrib.getParentClass();
            }
            URLClassLoader classLoader = this.createClassloader(parentClass.getClassLoader(), comp.getJavaProject());
            if (contrib != null) {
                contrib.beforeClassLoad(classLoader);
            }
            if (this.isValidType(viewClass = classLoader.loadClass(className.toString()))) break block13;
            return null;
        }
        try {
            return new ViewPartInfo(className.toString(), viewClass, comp);
        }
        catch (ClassNotFoundException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (IllegalArgumentException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (SecurityException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (UnsupportedClassVersionError e) {
            WorkbenchUtil.handleException(e, "UnsupportedClassVersionError: Make sure that you use the same java version to start the Eclipse IDE and for the workspace");
        }
        return null;
    }

    public IPreviewCustomizer getContributedPreviewCustomizer() {
        if (previewCustomizer == null) {
            IConfigurationElement[] config;
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".previewCustomizer");
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elm = iConfigurationElementArray[n2];
                try {
                    previewCustomizer = (IPreviewCustomizer)elm.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    WorkbenchUtil.handleException(e);
                }
                ++n2;
            }
        }
        return previewCustomizer;
    }

    public boolean isValidType(Class<?> type) {
        return Composite.class.isAssignableFrom(type) || ViewPart.class.isAssignableFrom(type);
    }

    private URLClassLoader createClassloader(ClassLoader parentClass, IJavaProject project) {
        String[] classPathEntries = null;
        try {
            classPathEntries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)project);
        }
        catch (JavaModelException ex) {
            WorkbenchUtil.handleException(ex);
            return null;
        }
        try {
            ArrayList<URL> urlList = new ArrayList<URL>();
            String[] stringArray = classPathEntries;
            int n = classPathEntries.length;
            int n2 = 0;
            while (n2 < n) {
                String entry = stringArray[n2];
                urlList.add(new Path(entry).toFile().toURI().toURL());
                ++n2;
            }
            URL[] urls = urlList.toArray(new URL[urlList.size()]);
            return new URLClassLoader(urls, parentClass);
        }
        catch (CoreException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (MalformedURLException e) {
            WorkbenchUtil.handleException(e);
        }
        return null;
    }
}

