/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.toolbox.previewer.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.eclipse.riena.toolbox.previewer.model.ViewPartInfo;
import org.eclipse.riena.toolbox.previewer.ui.WorkbenchUtil;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    public static boolean invokeMethod(String methodName, Object viewPart, Composite parent) {
        Method[] methodArray = viewPart.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (methodName.equals(method.getName())) {
                method.setAccessible(true);
                try {
                    method.invoke(viewPart, parent);
                }
                catch (IllegalArgumentException e) {
                    WorkbenchUtil.handleException(e, "Can not invoke method: " + methodName);
                    return false;
                }
                catch (IllegalAccessException e) {
                    WorkbenchUtil.handleException(e, "Can not invoke method: " + methodName);
                    return false;
                }
                catch (InvocationTargetException e) {
                    WorkbenchUtil.handleException(e, "Can not invoke method: " + methodName);
                    return false;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static Object newInstance(Class<?> type, Composite parent) {
        Constructor<?>[] constructorArray = type.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (Arrays.equals(new Class[]{Composite.class, Integer.TYPE}, constructor.getParameterTypes())) {
                constructor.setAccessible(true);
                return ReflectionUtil.callConstructor(constructor, parent, 0);
            }
            if (Arrays.equals(new Class[]{Composite.class}, constructor.getParameterTypes())) {
                constructor.setAccessible(true);
                return ReflectionUtil.callConstructor(constructor, parent);
            }
            ++n2;
        }
        return null;
    }

    public static Object callConstructor(Constructor<?> constructor, Object ... params) {
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(params);
        }
        catch (IllegalArgumentException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (InstantiationException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (IllegalAccessException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (InvocationTargetException e) {
            WorkbenchUtil.handleException(e);
        }
        return null;
    }

    public static Object loadClass(ViewPartInfo viewPart) {
        try {
            return viewPart.getType().newInstance();
        }
        catch (IllegalArgumentException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (SecurityException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (InstantiationException e) {
            WorkbenchUtil.handleException(e);
        }
        catch (IllegalAccessException e) {
            WorkbenchUtil.handleException(e);
        }
        return null;
    }

    private ReflectionUtil() {
    }
}

