/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.listener.ILocationListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractValueRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.swt.facades.BrowserFacade;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;

public class BrowserRidget
extends AbstractValueRidget
implements IBrowserRidget {
    private static final String PROPERTY_URL_INTERNAL = "urlInternal";
    private final InternalLocationListener internalLocationListener = new InternalLocationListener();
    private String url;
    private String text;

    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, Browser.class);
    }

    protected void bindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            this.updateUIControl();
            control.addLocationListener((LocationListener)this.internalLocationListener);
        }
    }

    protected void unbindUIControl() {
        Browser control = this.getUIControl();
        if (control != null) {
            control.removeLocationListener((LocationListener)this.internalLocationListener);
        }
        super.unbindUIControl();
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)PROPERTY_URL_INTERNAL);
    }

    public void addLocationListener(ILocationListener listener) {
        this.internalLocationListener.addLocationListener(listener);
    }

    public Browser getUIControl() {
        return (Browser)super.getUIControl();
    }

    public String getText() {
        return this.text;
    }

    public String getUrl() {
        return this.url;
    }

    public final String getUrlInternal() {
        return this.getUrl();
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void removeLocationListener(ILocationListener listener) {
        this.internalLocationListener.removeLocationListener(listener);
    }

    public void setText(String text) {
        if (!StringUtils.equals((CharSequence)this.text, (CharSequence)text)) {
            this.text = text;
            String oldUrl = this.url;
            this.url = null;
            this.updateUIControl();
            this.firePropertyChange(PROPERTY_URL_INTERNAL, oldUrl, this.url);
            this.firePropertyChange("url", oldUrl, this.url);
        }
    }

    public void setUrl(String url) {
        if (!StringUtils.equals((CharSequence)this.url, (CharSequence)url)) {
            String oldUrl = this.getUrl();
            this.text = null;
            this.url = url;
            this.updateUIControl();
            this.firePropertyChange(PROPERTY_URL_INTERNAL, oldUrl, this.url);
            this.firePropertyChange("url", oldUrl, this.url);
        }
    }

    public final void setUrlInternal(String url) {
        this.setUrl(url);
    }

    private String convertNullToEmpty(String string) {
        return string != null ? string : "";
    }

    private void updateUIControl() {
        Browser browser = this.getUIControl();
        if (browser != null) {
            if (this.text != null) {
                String browserText = BrowserFacade.getDefault().getText(browser);
                if (!this.text.equals(browserText)) {
                    this.internalLocationListener.unblock();
                    browser.setText(this.text);
                }
            } else {
                String notNullUrl = this.convertNullToEmpty(this.url);
                if (!notNullUrl.equals(browser.getUrl())) {
                    this.internalLocationListener.unblock();
                    browser.setUrl(notNullUrl);
                }
            }
        }
    }

    private final class InternalLocationListener
    implements LocationListener {
        private ListenerList<ILocationListener> listeners;
        private boolean canBlock = true;

        InternalLocationListener() {
        }

        void addLocationListener(ILocationListener listener) {
            Assert.isNotNull((Object)listener);
            if (this.listeners == null) {
                this.listeners = new ListenerList(ILocationListener.class);
            }
            this.listeners.add((Object)listener);
        }

        void removeLocationListener(ILocationListener listener) {
            if (this.listeners != null) {
                this.listeners.remove((Object)listener);
            }
        }

        void unblock() {
            this.canBlock = false;
        }

        public void changing(LocationEvent event) {
            if (this.canBlock) {
                if (BrowserRidget.this.isOutputOnly()) {
                    event.doit = false;
                }
                if (this.listeners != null && event.doit) {
                    for (ILocationListener listener : this.listeners) {
                        org.eclipse.riena.ui.ridgets.listener.LocationEvent locEvent = new org.eclipse.riena.ui.ridgets.listener.LocationEvent(event.location, event.doit, event.top);
                        event.doit &= listener.locationChanging(locEvent);
                    }
                }
            }
            this.canBlock = true;
        }

        public void changed(LocationEvent event) {
            if (event.top && !this.isNullOrAboutBlank(event.location) && !StringUtils.equals((CharSequence)BrowserRidget.this.url, (CharSequence)event.location)) {
                BrowserRidget.this.setUrl(event.location);
                if (this.listeners != null) {
                    org.eclipse.riena.ui.ridgets.listener.LocationEvent locEvent = new org.eclipse.riena.ui.ridgets.listener.LocationEvent(event.location, event.doit, event.top);
                    for (ILocationListener listener : this.listeners) {
                        listener.locationChanged(locEvent);
                    }
                }
            }
        }

        private boolean isNullOrAboutBlank(String url) {
            return url == null || "about:blank".equals(url);
        }
    }
}

