/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.internal.ui.swt.utils.RcpUtilities;
import org.eclipse.riena.internal.ui.swt.utils.ShellHelper;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TableRidgetLabelProvider
extends ObservableMapLabelProvider
implements ITableColorProvider,
ITableFontProvider {
    private static final Logger LOGGER = Log4r.getLogger(ShellHelper.class);
    private final int numColumns;
    private final IObservableMap[] attributeMap;
    private IColumnFormatter[] formatters;
    private Map<Object, Image> imageMap;

    public TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters) {
        this(attributeMap, formatters, attributeMap.length);
    }

    protected TableRidgetLabelProvider(IObservableMap[] attributeMap, IColumnFormatter[] formatters, int numColumns) {
        super(attributeMap);
        Assert.isLegal((numColumns == formatters.length ? 1 : 0) != 0, (String)String.format("expected %d formatters, got %d", numColumns, formatters.length));
        this.numColumns = numColumns;
        this.attributeMap = new IObservableMap[attributeMap.length];
        System.arraycopy(attributeMap, 0, this.attributeMap, 0, this.attributeMap.length);
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
        this.imageMap = new HashMap<Object, Image>();
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image result = null;
        if (columnIndex < this.attributeMap.length) {
            Object value;
            IColumnFormatter formatter = this.formatters[columnIndex];
            if (formatter != null) {
                Object formatterImage = formatter.getImage(element);
                if (formatterImage instanceof Image) {
                    result = (Image)formatterImage;
                } else if (formatterImage instanceof ImageData) {
                    ImageData formatterImageData = (ImageData)formatterImage;
                    Display display = this.getDisplay();
                    if (display != null) {
                        Image oldImage = this.imageMap.get(element);
                        if (!SwtUtilities.isDisposed((Resource)oldImage)) {
                            oldImage.dispose();
                        }
                        result = new Image((Device)display, formatterImageData);
                        this.imageMap.put(element, result);
                    }
                }
            }
            if (result == null && (value = this.attributeMap[columnIndex].get(element)) instanceof Boolean) {
                String key = (Boolean)value != false ? "IMG_CHECKED" : "IMG_UNCHECKED";
                result = Activator.getSharedImage(key);
            }
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        this.disposeImages();
        this.imageMap = null;
    }

    public void disposeImages() {
        for (Map.Entry<Object, Image> entry : this.imageMap.entrySet()) {
            Image image = entry.getValue();
            if (SwtUtilities.isDisposed((Resource)image)) continue;
            image.dispose();
        }
        this.imageMap.clear();
    }

    public void disposeImageOfElement(Object element) {
        Image image = this.imageMap.get(element);
        if (image == null) {
            LOGGER.log(2, "No image found for element: " + element.toString());
            return;
        }
        image.dispose();
        this.imageMap.remove(element);
    }

    private Display getDisplay() {
        Shell shell = RcpUtilities.getWorkbenchShell();
        if (shell == null || shell.isDisposed()) {
            LOGGER.log(2, "No shell of the application found!");
            return null;
        }
        return shell.getDisplay();
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = null;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            result = formatter.getText(element);
        }
        if (result == null) {
            result = super.getColumnText(element, columnIndex);
        }
        return result;
    }

    public Color getForeground(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return (Color)formatter.getForeground(element);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return (Color)formatter.getBackground(element);
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return (Font)formatter.getFont(element);
        }
        return null;
    }

    public Object getColumnValue(Object element, int columnIndex) {
        if (columnIndex < this.attributeMap.length) {
            return this.attributeMap[columnIndex].get(element);
        }
        return null;
    }

    public String getToolTipText(Object element, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTip(element);
        }
        return null;
    }

    public Image getToolTipImage(Object object, int columnIndex) {
        Object image;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null && (image = formatter.getToolTipImage(object)) instanceof Image) {
            return (Image)image;
        }
        return null;
    }

    public Color getToolTipBackgroundColor(Object object, int columnIndex) {
        Object color;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null && (color = formatter.getToolTipBackgroundColor(object)) instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Color getToolTipForegroundColor(Object object, int columnIndex) {
        Object color;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null && (color = formatter.getToolTipForegroundColor(object)) instanceof Color) {
            return (Color)color;
        }
        return null;
    }

    public Font getToolTipFont(Object object, int columnIndex) {
        Object font;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null && (font = formatter.getToolTipFont(object)) instanceof Font) {
            return (Font)font;
        }
        return null;
    }

    public Point getToolTipShift(Object object, int columnIndex) {
        Object point;
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null && (point = formatter.getToolTipShift(object)) instanceof Point) {
            return (Point)point;
        }
        return null;
    }

    public int getToolTipTimeDisplayed(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipTimeDisplayed(object);
        }
        return 0;
    }

    public int getToolTipDisplayDelayTime(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipDisplayDelayTime(object);
        }
        return 0;
    }

    public int getToolTipStyle(Object object, int columnIndex) {
        IColumnFormatter formatter = this.getFormatter(columnIndex);
        if (formatter != null) {
            return formatter.getToolTipStyle(object);
        }
        return 32;
    }

    protected IColumnFormatter getFormatter(int columnIndex) {
        return columnIndex < this.formatters.length ? this.formatters[columnIndex] : null;
    }

    int getColumnCount() {
        return this.formatters.length;
    }

    void setFormatters(IColumnFormatter[] formatters) {
        Assert.isLegal((this.numColumns == formatters.length ? 1 : 0) != 0, (String)String.format("expected %d formatters, got %d", this.numColumns, formatters.length));
        this.formatters = new IColumnFormatter[formatters.length];
        System.arraycopy(formatters, 0, this.formatters, 0, this.formatters.length);
    }
}

