/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSWTWidgetRidget
extends AbstractRidget
implements IBasicMarkableRidget {
    private Widget uiControl;
    private String toolTip = null;
    private ErrorMessageMarker errorMarker;
    private DisabledMarker disabledMarker;
    private MandatoryMarker mandatoryMarker;
    private OutputMarker outputMarker;
    private HiddenMarker hiddenMarker;
    private AbstractMarkerSupport markerSupport;
    private Listener visibilityListener;

    public static boolean isBean(Class<?> clazz) {
        try {
            clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public final synchronized void addMarker(IMarker marker) {
        if (this.markerSupport == null) {
            this.markerSupport = this.createMarkerSupport();
            this.markerSupport.setRidget((IBasicMarkableRidget)this);
            this.unbindMarkerSupport();
        }
        if (marker instanceof MandatoryMarker) {
            ((MandatoryMarker)marker).setDisabled(this.isDisableMandatoryMarker());
        }
        this.markerSupport.addMarker(marker);
    }

    public String getID() {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        return locator.locateBindingProperty((Object)this.getUIControl());
    }

    public Set<Class<IMarker>> getHiddenMarkerTypes() {
        if (this.markerSupport != null) {
            return this.markerSupport.getHiddenMarkerTypes();
        }
        return new HashSet<Class<IMarker>>();
    }

    public final Collection<IMarker> getMarkers() {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkers();
        }
        return Collections.emptySet();
    }

    public final <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkersOfType(type);
        }
        return Collections.emptySet();
    }

    public final String getToolTipText() {
        return this.toolTip;
    }

    public Widget getUIControl() {
        return this.uiControl;
    }

    public Set<Class<IMarker>> hideMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.markerSupport == null) {
            this.markerSupport = this.createMarkerSupport();
            this.markerSupport.setRidget((IBasicMarkableRidget)this);
        }
        return this.markerSupport.hideMarkersOfType((Class[])types);
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isEnabled() {
        return this.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    public final boolean isErrorMarked() {
        return !this.getMarkersOfType(ErrorMarker.class).isEmpty();
    }

    public boolean isFocusable() {
        return false;
    }

    @Deprecated
    public final boolean isMandatory() {
        return !this.getMarkersOfType(MandatoryMarker.class).isEmpty();
    }

    public final boolean isOutputOnly() {
        return !this.getMarkersOfType(OutputMarker.class).isEmpty();
    }

    public final void removeAllMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.removeAllMarkers();
        }
    }

    public final boolean removeMarker(IMarker marker) {
        if (this.markerSupport != null) {
            return this.markerSupport.removeMarker(marker);
        }
        return false;
    }

    public void requestFocus() {
    }

    public synchronized void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.disabledMarker != null) {
                this.removeMarker((IMarker)this.disabledMarker);
            }
        } else {
            if (this.disabledMarker == null) {
                this.disabledMarker = new DisabledMarker();
            }
            this.addMarker((IMarker)this.disabledMarker);
        }
    }

    public final void setErrorMarked(boolean errorMarked) {
        this.setErrorMarked(errorMarked, null);
    }

    public void setFocusable(boolean focusable) {
    }

    public final void setMandatory(boolean mandatory) {
        if (!mandatory) {
            if (this.mandatoryMarker != null) {
                this.removeMarker((IMarker)this.mandatoryMarker);
            }
        } else {
            if (this.mandatoryMarker == null) {
                this.mandatoryMarker = new MandatoryMarker();
            }
            this.addMarker((IMarker)this.mandatoryMarker);
        }
    }

    public final void setOutputOnly(boolean outputOnly) {
        if (!outputOnly) {
            if (this.outputMarker != null) {
                this.removeMarker((IMarker)this.outputMarker);
            }
        } else {
            if (this.outputMarker == null) {
                this.outputMarker = new OutputMarker();
            }
            this.addMarker((IMarker)this.outputMarker);
        }
    }

    public final void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTip();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    public final void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.uninstallListeners();
        this.unbindUIControl();
        this.unbindMarkerSupport();
        this.uiControl = (Widget)uiControl;
        this.bindMarkerSupport();
        this.updateEnabled();
        this.updateMarkers();
        this.updateToolTip();
        this.bindUIControl();
        this.installListeners();
    }

    public final void setVisible(boolean visible) {
        if (this.hiddenMarker == null) {
            this.hiddenMarker = new HiddenMarker();
        }
        if (visible) {
            this.removeMarker((IMarker)this.hiddenMarker);
        } else {
            this.addMarker((IMarker)this.hiddenMarker);
        }
    }

    public Set<Class<IMarker>> showMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.markerSupport == null) {
            return new HashSet<Class<IMarker>>();
        }
        return this.markerSupport.showMarkersOfType((Class[])types);
    }

    protected abstract void checkUIControl(Object var1);

    protected abstract void bindUIControl();

    protected abstract void unbindUIControl();

    public abstract boolean isDisableMandatoryMarker();

    protected abstract void updateEnabled();

    protected abstract void updateToolTip();

    protected AbstractMarkerSupport createMarkerSupport() {
        AbstractMarkerSupport lnfMarkerSupport = null;
        if (LnfManager.getLnf() != null) {
            lnfMarkerSupport = LnfManager.getLnf().getMarkerSupport(((Object)((Object)this)).getClass());
        }
        if (lnfMarkerSupport == null) {
            lnfMarkerSupport = new MarkerSupport();
        }
        lnfMarkerSupport.init((IBasicMarkableRidget)this, this.propertyChangeSupport);
        Assert.isNotNull((Object)lnfMarkerSupport, (String)"Marker support is null!");
        return lnfMarkerSupport;
    }

    protected final void disableMandatoryMarkers(boolean disable) {
        for (IMarker iMarker : this.getMarkersOfType(MandatoryMarker.class)) {
            MandatoryMarker mMarker = (MandatoryMarker)iMarker;
            mMarker.setDisabled(disable);
        }
    }

    protected final synchronized void flash() {
        if (this.getUIControl() != null) {
            if (this.markerSupport == null) {
                this.markerSupport = this.createMarkerSupport();
                this.markerSupport.setRidget((IBasicMarkableRidget)this);
            }
            this.markerSupport.flash();
        }
    }

    protected Image getManagedImage(String key) {
        Image image = ImageStore.getInstance().getImage(key);
        if (image == null) {
            image = ImageStore.getInstance().getMissingImage();
        }
        return image;
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    protected void installListeners() {
        if (this.getUIControl() != null) {
            if (this.visibilityListener == null) {
                this.visibilityListener = new VisibilityListener();
            }
            if (this.getUIControl() instanceof Control) {
                this.addHierarchyVisibilityListener(((Control)this.getUIControl()).getParent(), this.visibilityListener);
            }
        }
    }

    protected final void setErrorMarked(boolean errorMarked, String message) {
        if (!errorMarked) {
            if (this.errorMarker != null) {
                this.removeMarker((IMarker)this.errorMarker);
            }
        } else {
            if (this.errorMarker == null) {
                this.errorMarker = new ErrorMessageMarker(message);
            } else {
                this.errorMarker.setMessage(message);
            }
            this.addMarker((IMarker)this.errorMarker);
        }
    }

    protected void uninstallListeners() {
        if (this.getUIControl() instanceof Control && this.visibilityListener != null) {
            this.removeHierarchyVisibilityListener(((Control)this.getUIControl()).getParent(), this.visibilityListener);
        }
    }

    public void updateMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.updateMarkers();
        }
    }

    private void addHierarchyVisibilityListener(Composite parent, Listener listener) {
        if (parent != null && !parent.isDisposed()) {
            parent.addListener(22, listener);
            parent.addListener(23, listener);
            this.addHierarchyVisibilityListener(parent.getParent(), listener);
        }
    }

    private void bindMarkerSupport() {
        if (this.markerSupport != null) {
            this.markerSupport.bind();
        }
    }

    private void removeHierarchyVisibilityListener(Composite parent, Listener listener) {
        if (parent != null && !parent.isDisposed()) {
            parent.removeListener(22, listener);
            parent.removeListener(23, listener);
            this.removeHierarchyVisibilityListener(parent.getParent(), listener);
        }
    }

    private void unbindMarkerSupport() {
        if (this.markerSupport != null) {
            this.markerSupport.unbind();
        }
    }

    private final class VisibilityListener
    implements Listener {
        private VisibilityListener() {
        }

        public void handleEvent(Event event) {
            final Widget control = AbstractSWTWidgetRidget.this.getUIControl();
            if (AbstractSWTWidgetRidget.this.markerSupport != null && !AbstractSWTWidgetRidget.this.getMarkers().isEmpty() && !SwtUtilities.isDisposed((Widget)control)) {
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!SwtUtilities.isDisposed((Widget)control)) {
                            AbstractSWTWidgetRidget.this.markerSupport.fireShowingPropertyChangeEvent();
                        }
                    }
                });
            }
        }
    }
}

